/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.model.SpaceExporter;
import com.brikit.themepress.util.ThemePress;
import java.io.File;
import java.util.Collections;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class ImportArchitectPagesAction
extends ThemePressActionSupport {
    public String doDefault() {
        return "success";
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String execute() {
        for (String parameterName : Collections.list(this.getMultiPartRequest().getFileParameterNames())) {
            UploadedFile[] files = this.getMultiPartRequest().getFiles(parameterName);
            for (int i = 0; i < files.length; ++i) {
                UploadedFile uploadedFile;
                if (files[i] == null || !(uploadedFile = files[i]).isFile()) continue;
                File importFile = (File)uploadedFile.getContent();
                String filename = this.getMultiPartRequest().getFileNames(parameterName)[i];
                BrikitLog.log((String)("Importing architect pages from: " + importFile.getAbsolutePath()));
                if (!filename.endsWith(".zip")) {
                    this.addActionError("Architect pages must be in a .zip file.", new Object[]{filename});
                    return "error";
                }
                try {
                    File zipFile = BrikitFile.getBrikitFile((String)"theme-press-architect-pages.zip");
                    importFile.renameTo(zipFile);
                    SpaceExporter exporter = new SpaceExporter(zipFile, ThemePress.getThemePressDefaultSpace(), true, "theme-press-architect-pages");
                    exporter.importSpace(true);
                    continue;
                }
                catch (Exception ex) {
                    BrikitLog.logError((String)("Failed to upload architect pages zip " + filename), (Exception)ex);
                    this.addActionError((String)(BrikitString.isSet((String)ex.getMessage()) ? ex.getMessage() : "Unable to read " + filename));
                    return "error";
                }
            }
        }
        ThemePress.resetCaches();
        return "success";
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

