/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.brikit.core.macros.BrikitBaseMacro;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemeProperties;

public abstract class BrikitColorHandlingMacro
extends BrikitBaseMacro {
    public void convertColorPaletteReference(String colorParameterKey, BrikitMacroContext macroContext) {
        if (macroContext.hasStringValue(colorParameterKey)) {
            macroContext.velocityContextAdd((Object)colorParameterKey, (Object)this.colorValue(colorParameterKey, null, macroContext));
        }
    }

    public String colorValue(String key, String defaultValue, BrikitMacroContext macroContext) {
        String color = (String)macroContext.getParameters().get(key);
        if (!BrikitString.isSet((String)color)) {
            color = defaultValue;
        }
        if (!BrikitString.isSet((String)color)) {
            return null;
        }
        String paletteColor = color;
        ThemeProperties properties = BrikitThemeSettings.getThemeProperties(macroContext.getPage());
        if (paletteColor.equals("$primaryColor")) {
            color = properties.getPrimaryColor();
        } else if (paletteColor.equals("$secondaryColor")) {
            color = properties.getSecondaryColor();
        } else if (paletteColor.equals("$tertiaryColor")) {
            color = properties.getTertiaryColor();
        } else if (paletteColor.equals("$lightColor")) {
            color = properties.getLightColor();
        } else if (paletteColor.equals("$mediumColor")) {
            color = properties.getMediumColor();
        } else if (paletteColor.equals("$darkColor")) {
            color = properties.getDarkColor();
        } else if (paletteColor.equals("$lightGrayColor")) {
            color = properties.getLightGrayColor();
        } else if (paletteColor.equals("$mediumGrayColor")) {
            color = properties.getMediumGrayColor();
        } else if (paletteColor.equals("$darkGrayColor")) {
            color = properties.getDarkGrayColor();
        } else if (paletteColor.equals("$whiteColor")) {
            color = properties.getWhiteColor();
        }
        return color;
    }

    public void setDefaultColorParameter(String key, String value, BrikitMacroContext macroContext) {
        String color = this.colorValue(key, value, macroContext);
        if (BrikitString.isSet((String)color)) {
            macroContext.velocityContextAdd((Object)key, (Object)color);
        }
    }
}

