/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitFile;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.model.SpaceWrapper;
import com.brikit.themepress.util.ThemePress;
import java.io.File;

public class DownloadSpaceListAction
extends ThemePressActionSupport {
    protected static final String FILENAME = "themed-spaces.tsv";
    protected String downloadPath;

    public String execute() throws Exception {
        File dataFile = BrikitFile.getConfluenceTempDirectoryPath((String)FILENAME);
        StringBuilder builder = new StringBuilder();
        builder.append(Confluence.getText((String)"com.brikit.themepress.space.key")).append("\t").append(Confluence.getText((String)"com.brikit.themepress.space.name")).append("\t").append(Confluence.getText((String)"com.brikit.themepress.settings.theme.name")).append("\t").append(Confluence.getText((String)"com.brikit.themepress.space.type")).append("\t").append(Confluence.getText((String)"com.brikit.themepress.space.status")).append("\n");
        for (Space space : ThemePress.getThemedSpaces()) {
            builder.append(space.getKey()).append("\t").append(space.getName()).append("\t").append(SpaceWrapper.get(space).getThemeName()).append("\t").append(space.getSpaceType()).append("\t").append(space.getSpaceStatus()).append("\n");
        }
        BrikitFile.write((String)builder.toString(), (File)dataFile);
        this.setDownloadPath(BrikitFile.prepareDownloadPath((String)dataFile.getPath()) + "?contentType=application/tsv");
        BrikitFile.allowUserToDownload((File)dataFile);
        return "success";
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

