/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.servlet;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.atlassian.confluence.util.HtmlUtil;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import java.util.StringTokenizer;

public class PageAttachmentPathConverter
implements PathConverter {
    protected static final String PATH_PREFIX = "attachment/";
    protected static final String NEW_PATH = "/download/attachments/";

    public boolean handles(String pathString) {
        if (!pathString.startsWith(PATH_PREFIX)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(pathString, "/");
        if (st.countTokens() != 4) {
            return false;
        }
        PathBits path = new PathBits(pathString);
        Page page = Confluence.getPage((String)path.getSpaceKey(), (String)path.getPageTitle());
        return page != null && Confluence.getAttachment((AbstractPage)page, (String)path.getAttachmentName()) != null;
    }

    public ConvertedPath getPath(String pathString) {
        PathBits path = new PathBits(pathString);
        Page page = Confluence.getPage((String)path.getSpaceKey(), (String)path.getPageTitle());
        return new ConvertedPath(NEW_PATH + page.getIdAsString() + "/" + path.getAttachmentName());
    }

    protected class PathBits {
        protected String spaceKey;
        protected String pageTitle;
        protected String attachmentName;

        public PathBits(String path) {
            try {
                StringTokenizer st = new StringTokenizer(path, "/");
                st.nextToken();
                this.setSpaceKey(st.nextToken());
                this.setPageTitle(st.nextToken());
                this.setAttachmentName(st.nextToken());
            }
            catch (Exception ex) {
                BrikitLog.logError((String)"Failed to parse attachment path.", (Exception)ex);
            }
        }

        public String getSpaceKey() {
            return this.spaceKey;
        }

        public void setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
        }

        public String getPageTitle() {
            return this.pageTitle;
        }

        public void setPageTitle(String pageTitle) {
            pageTitle = HtmlUtil.urlDecode((String)pageTitle);
            this.pageTitle = pageTitle = pageTitle.replaceAll("&forwardslash;", "/").replaceAll("&backwardslash;", "\\\\");
        }

        public String getAttachmentName() {
            return this.attachmentName;
        }

        public void setAttachmentName(String attachmentName) {
            this.attachmentName = HtmlUtil.urlDecode((String)attachmentName);
        }
    }
}

