/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.designer.ThemeChangeset;
import com.brikit.themepress.designer.ThemeUndoStack;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemePlugin;
import com.brikit.themepress.settings.ThemeProperties;
import java.util.concurrent.ExecutionException;

public class EditThemePropertyAction
extends ThemePressActionSupport {
    protected String property;
    protected String value;

    public String execute() throws Exception {
        String oldValue = ThemeProperties.getThemeProperties(this.getThemeName()).get(this.getProperty());
        ThemePlugin.apply(this.getThemeName(), this.getProperty(), this.getValue());
        ThemeChangeset changeset = this.getUndoStack().addChange(this.getProperty(), oldValue, this.getValue());
        this.setUndoStackUpdates(true, changeset.getNewValues(), "Change", true);
        return "success";
    }

    public String redo() throws Exception {
        String changedValue = this.getUndoStack().hasRedo() ? this.getUndoStack().nextRedo().getNewValues() : "{}";
        this.getUndoStack().redo();
        this.setUndoStackUpdates(true, changedValue, "Redo", false);
        return "success";
    }

    public String status() throws Exception {
        this.setUndoStackUpdates(false, null, "Status", false);
        return "success";
    }

    public String undo() throws Exception {
        String changedValue = this.getUndoStack().hasUndo() ? this.getUndoStack().nextUndo().getOldValues() : "{}";
        this.getUndoStack().undo();
        this.setUndoStackUpdates(true, changedValue, "Undo", false);
        return "success";
    }

    protected ThemeUndoStack getUndoStack() {
        return ThemeUndoStack.getUndoStack(this.getThemeName());
    }

    public String getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }

    public void setUndoStackUpdates(boolean cssRefreshNeeded, String changedValue, String whatHappened, boolean manual) throws ExecutionException {
        ThemeChangeset nextUndo = this.getUndoStack().nextUndo();
        ThemeChangeset nextRedo = this.getUndoStack().nextRedo();
        JSONObject json = new JSONObject();
        json.put("whatHappened", (Object)whatHappened);
        json.put("undo", nextUndo == null ? Boolean.valueOf(false) : nextUndo.getOldValues());
        json.put("redo", nextRedo == null ? Boolean.valueOf(false) : nextRedo.getNewValues());
        json.put("reloadCSS", cssRefreshNeeded);
        if (manual) {
            json.put("manual", true);
        }
        if (cssRefreshNeeded) {
            json.put("cacheKey", (Object)BrikitThemeSettings.cssBundle("all", this.getThemeName()));
        }
        if (BrikitString.isSet((String)changedValue)) {
            json.put("changed", (Object)changedValue);
        }
        this.result = json.toString();
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

