/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.designer;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.BrikitBandanaManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;

public class ThemeDesignerAccess {
    protected static final String PAGE_TAB_ACCESS_GROUPS = "com.brikit.themepress.access.groups.tab.page";
    protected static final String ARCHITECT_TAB_ACCESS_GROUPS = "com.brikit.themepress.access.groups.tab.architect";
    protected static final String THEME_TAB_ACCESS_GROUPS = "com.brikit.themepress.access.groups.tab.theme";

    public static void addArchitectTabAccessGroup(String group, String spaceKey) throws Exception {
        BrikitList<String> groups = ThemeDesignerAccess.architectTabAccessGroups(spaceKey);
        if (!Confluence.isValidConfluenceGroupName(group)) {
            throw new Exception(Confluence.getText("brikit.config.invalid.group"));
        }
        if (groups.contains(group)) {
            return;
        }
        groups.add(group);
        ThemeDesignerAccess.saveArchitectTabAccessGroups(groups, spaceKey);
    }

    public static boolean hasArchitectTabAccess(String spaceKey) {
        BrikitList<String> groups = ThemeDesignerAccess.architectTabAccessGroups(spaceKey);
        return Confluence.canAdministerSpace(spaceKey) || Confluence.isGroupMember(groups);
    }

    public static void removeArchitectTabAccessGroup(String group, String spaceKey) {
        Space space = Confluence.getSpace(spaceKey);
        if (space == null) {
            return;
        }
        BrikitList<String> groups = ThemeDesignerAccess.architectTabAccessGroups(spaceKey);
        if (!groups.contains(group)) {
            return;
        }
        groups.remove(group);
        ThemeDesignerAccess.saveArchitectTabAccessGroups(groups, spaceKey);
    }

    protected static void saveArchitectTabAccessGroups(BrikitList<String> groups, String spaceKey) {
        Space space = Confluence.getSpace(spaceKey);
        if (space == null) {
            return;
        }
        BrikitBandanaManager.saveEntry(space, ARCHITECT_TAB_ACCESS_GROUPS, groups.join(","));
    }

    public static BrikitList<String> architectTabAccessGroups(String spaceKey) {
        Space space = Confluence.getSpace(spaceKey);
        if (space == null) {
            return new BrikitList<String>();
        }
        return BrikitString.splitCommaSeparated(BrikitBandanaManager.getEntry(space, ARCHITECT_TAB_ACCESS_GROUPS));
    }

    public static void addPageTabAccessGroup(String group, String spaceKey) throws Exception {
        BrikitList<String> groups = ThemeDesignerAccess.pageTabAccessGroups(spaceKey);
        if (!Confluence.isValidConfluenceGroupName(group)) {
            throw new Exception(Confluence.getText("brikit.config.invalid.group"));
        }
        if (groups.contains(group)) {
            return;
        }
        groups.add(group);
        ThemeDesignerAccess.savePageTabAccessGroups(groups, spaceKey);
    }

    public static boolean hasPageTabAccess(AbstractPage abstractPage) {
        if (abstractPage == null) {
            return false;
        }
        BrikitList<String> groups = ThemeDesignerAccess.pageTabAccessGroups(Confluence.getSpaceKey(abstractPage));
        return Confluence.canEdit(abstractPage) && (groups.isEmpty() || Confluence.isGroupMember(groups) || Confluence.isConfluenceAdministrator());
    }

    public static boolean hasPageTabAccess(String pageIdAsString) {
        return ThemeDesignerAccess.hasPageTabAccess(Confluence.getPageOrBlogPost(pageIdAsString));
    }

    public static void removePageTabAccessGroup(String group, String spaceKey) {
        Space space = Confluence.getSpace(spaceKey);
        if (space == null) {
            return;
        }
        BrikitList<String> groups = ThemeDesignerAccess.pageTabAccessGroups(spaceKey);
        if (!groups.contains(group)) {
            return;
        }
        groups.remove(group);
        ThemeDesignerAccess.savePageTabAccessGroups(groups, spaceKey);
    }

    protected static void savePageTabAccessGroups(BrikitList<String> groups, String spaceKey) {
        Space space = Confluence.getSpace(spaceKey);
        if (space == null) {
            return;
        }
        BrikitBandanaManager.saveEntry(space, PAGE_TAB_ACCESS_GROUPS, groups.join(","));
    }

    public static BrikitList<String> pageTabAccessGroups(String spaceKey) {
        Space space = Confluence.getSpace(spaceKey);
        if (space == null) {
            return new BrikitList<String>();
        }
        return BrikitString.splitCommaSeparated(BrikitBandanaManager.getEntry(space, PAGE_TAB_ACCESS_GROUPS));
    }

    public static void addThemeTabAccessGroup(String group) throws Exception {
        BrikitList<String> groups = ThemeDesignerAccess.themeTabAccessGroups();
        if (!Confluence.isValidConfluenceGroupName(group)) {
            throw new Exception(Confluence.getText("brikit.config.invalid.group"));
        }
        if (groups.contains(group)) {
            return;
        }
        groups.add(group);
        ThemeDesignerAccess.saveThemeTabAccessGroups(groups);
    }

    public static boolean hasThemeTabAccess() {
        return Confluence.isConfluenceAdministrator() || Confluence.isGroupMember(ThemeDesignerAccess.themeTabAccessGroups());
    }

    public static void removeThemeTabAccessGroup(String group) {
        BrikitList<String> groups = ThemeDesignerAccess.themeTabAccessGroups();
        if (!groups.contains(group)) {
            return;
        }
        groups.remove(group);
        ThemeDesignerAccess.saveThemeTabAccessGroups(groups);
    }

    protected static void saveThemeTabAccessGroups(BrikitList<String> groups) {
        BrikitBandanaManager.saveEntry(null, THEME_TAB_ACCESS_GROUPS, groups.join(","));
    }

    public static BrikitList<String> themeTabAccessGroups() {
        return BrikitString.splitCommaSeparated(BrikitBandanaManager.getEntry(null, THEME_TAB_ACCESS_GROUPS));
    }
}

