/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.brikit.core.confluence.BrikitDataStore;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.List;

public class TargetedSearch {
    protected static final String DEFAULT_FILTERS_TOOLTIP_KEY = "com.brikit.targetedsearch.search.panel.default.tooltip";
    protected static final String ALL_FILTERS_TOOLTIP_KEY = "com.brikit.targetedsearch.search.panel.all.tooltip";
    protected static final String ANY_FILTERS_TOOLTIP_KEY = "com.brikit.targetedsearch.search.panel.any.tooltip";
    protected static final String DELIMITER = ",";

    public static boolean canEditTaxonomy() {
        return Confluence.isConfluenceAdministrator() || Confluence.isGroupMember(TargetedSearch.taxonomyEditorUserGroups());
    }

    public static String getAllFiltersTooltip() {
        String tooltip = BrikitDataStore.getString((String)"", (String)"allFiltersTooltip");
        return BrikitString.isSet((String)tooltip) ? tooltip : Confluence.getText((String)ALL_FILTERS_TOOLTIP_KEY);
    }

    public static String getAnyFiltersTooltip() {
        String tooltip = BrikitDataStore.getString((String)"", (String)"anyFiltersTooltip");
        return BrikitString.isSet((String)tooltip) ? tooltip : Confluence.getText((String)ANY_FILTERS_TOOLTIP_KEY);
    }

    public static String getDefaultFiltersTooltip() {
        String tooltip = BrikitDataStore.getString((String)"", (String)"defaultFiltersTooltip");
        return BrikitString.isSet((String)tooltip) ? tooltip : Confluence.getText((String)DEFAULT_FILTERS_TOOLTIP_KEY);
    }

    public static String getMoreHelpLink() {
        return BrikitDataStore.getString((String)"", (String)"moreSearchHelpLink");
    }

    public static String getSearchMacroParameters() {
        return BrikitDataStore.getString((String)"", (String)"searchMacroParameters");
    }

    public static BrikitList<String> getSearchMacroParametersList() {
        return BrikitString.splitCommaSeparated((String)TargetedSearch.getSearchMacroParameters());
    }

    public static boolean isLicensed(PluginLicenseManager pluginLicenseManager) {
        if (pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                return false;
            }
            return license.isActive();
        }
        return false;
    }

    public static void saveAllFiltersTooltip(String tooltip) {
        BrikitDataStore.setString((String)"", (String)"allFiltersTooltip", (String)tooltip);
    }

    public static void saveAnyFiltersTooltip(String tooltip) {
        BrikitDataStore.setString((String)"", (String)"anyFiltersTooltip", (String)tooltip);
    }

    public static void saveDefaultFiltersTooltip(String tooltip) {
        BrikitDataStore.setString((String)"", (String)"defaultFiltersTooltip", (String)tooltip);
    }

    public static void saveMoreHelpLink(String moreHelpLink) {
        BrikitDataStore.setString((String)"", (String)"moreSearchHelpLink", (String)moreHelpLink);
    }

    public static void saveSearchMacroParameters(String searchMacroParameters) {
        BrikitDataStore.setString((String)"", (String)"searchMacroParameters", (String)searchMacroParameters);
    }

    public static void saveTaxonomyEditorUserGroups(List<String> usergroups) {
        BrikitDataStore.setString((String)"", (String)"taxonomyEditorUserGroups", (String)new BrikitList(usergroups).join(DELIMITER));
    }

    public static List<String> taxonomyEditorUserGroups() {
        return BrikitString.split((String)BrikitDataStore.getString((String)"", (String)"taxonomyEditorUserGroups"), (String)DELIMITER);
    }
}

