/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.json.jsonorg.JSONArray;
import com.brikit.core.confluence.BrikitDataStore;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchSettings {
    public static final String FOLKSONOMY_GROUP_NAME = "::FOLKSONOMY::";
    public static final int MAX_QUICK_SEARCH_RESULTS = 15;
    public static final int MAX_SEARCH_RESULTS = 200;

    public static boolean allowDuplicateFilterNames() {
        return BrikitDataStore.getBoolean((String)"", (String)"com.brikit.targetedsearch.allow.duplicate.filter.names");
    }

    protected static JSONArray getTargetedSearchData() {
        String rawSettings = BrikitDataStore.getString((String)"", (String)"com.brikit.targetedsearch.config");
        if (!BrikitString.isSet((String)rawSettings)) {
            return new JSONArray();
        }
        try {
            return new JSONArray(rawSettings);
        }
        catch (Exception e) {
            BrikitLog.logError((String)("Unable to parse persisted settings: " + rawSettings), (Exception)e);
            return new JSONArray();
        }
    }

    public static JSONArray getFolksonomy() {
        String raw = BrikitDataStore.getString((String)"", (String)"com.brikit.targetedsearch.folksonomy");
        if (!BrikitString.isSet((String)raw)) {
            return new JSONArray();
        }
        try {
            return new JSONArray(raw);
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Unable to parse persisted folksonomy: " + raw), (Exception)ex);
            return new JSONArray();
        }
    }

    public static boolean isRichLinksDisabled() {
        return BrikitDataStore.getBoolean((String)"", (String)"com.brikit.targetedsearch.rich.links.disabled");
    }

    protected static void saveFolksonomy(JSONArray folksonomyData) {
        BrikitDataStore.setString((String)"", (String)"com.brikit.targetedsearch.folksonomy", (String)folksonomyData.toString());
    }

    public static void setAllowDuplicateFilterNames(boolean toggle) {
        BrikitDataStore.setBoolean((String)"", (String)"com.brikit.targetedsearch.allow.duplicate.filter.names", (Boolean)toggle);
    }

    protected static void saveSettings(JSONArray settingsData) {
        BrikitDataStore.setString((String)"", (String)"com.brikit.targetedsearch.config", (String)settingsData.toString());
        FilterGroup.resetCaches();
    }

    public static void setRichLinksDisabled(boolean toggle) {
        BrikitDataStore.setBoolean((String)"", (String)"com.brikit.targetedsearch.rich.links.disabled", (Boolean)toggle);
    }

    public static Map<String, List<String>> sortFilterLabelsByFilterGroup(List<String> filterLabels) {
        HashMap<String, List<String>> selectedFilterGroups = new HashMap<String, List<String>>();
        if (filterLabels == null) {
            return selectedFilterGroups;
        }
        for (String filterLabel : filterLabels) {
            String filterGroupName;
            Filter filter = Filter.getFilterByLabel(filterLabel);
            String string = filterGroupName = filter == null ? FOLKSONOMY_GROUP_NAME : filter.getParent().getDisplayName();
            if (!selectedFilterGroups.containsKey(filterGroupName)) {
                selectedFilterGroups.put(filterGroupName, new ArrayList());
            }
            ((List)selectedFilterGroups.get(filterGroupName)).add(filterLabel);
        }
        return selectedFilterGroups;
    }
}

