/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.brikit.core.confluence.BrikitBandanaManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.List;

public class TargetedSearch {
    protected static final String MORE_SEARCH_HELP_LINK = "moreSearchHelpLink";
    protected static final String SEARCH_MACRO_PARAMETERS = "searchMacroParameters";
    protected static final String TAXONOMY_EDITOR_USER_GROUPS = "taxonomyEditorUserGroups";
    protected static final String DEFAULT_FILTERS_TOOLTIP = "defaultFiltersTooltip";
    protected static final String ALL_FILTERS_TOOLTIP = "allFiltersTooltip";
    protected static final String ANY_FILTERS_TOOLTIP = "anyFiltersTooltip";
    protected static final String DEFAULT_FILTERS_TOOLTIP_KEY = "com.brikit.targetedsearch.search.panel.default.tooltip";
    protected static final String ALL_FILTERS_TOOLTIP_KEY = "com.brikit.targetedsearch.search.panel.all.tooltip";
    protected static final String ANY_FILTERS_TOOLTIP_KEY = "com.brikit.targetedsearch.search.panel.any.tooltip";
    protected static final String DELIMITER = ",";

    public static boolean canEditTaxonomy() {
        return Confluence.isConfluenceAdministrator() || Confluence.isGroupMember(TargetedSearch.taxonomyEditorUserGroups());
    }

    public static String getAllFiltersTooltip() {
        String tooltip = BrikitBandanaManager.getEntry(null, (String)ALL_FILTERS_TOOLTIP);
        return BrikitString.isSet((String)tooltip) ? tooltip : Confluence.getText((String)ALL_FILTERS_TOOLTIP_KEY);
    }

    public static String getAnyFiltersTooltip() {
        String tooltip = BrikitBandanaManager.getEntry(null, (String)ANY_FILTERS_TOOLTIP);
        return BrikitString.isSet((String)tooltip) ? tooltip : Confluence.getText((String)ANY_FILTERS_TOOLTIP_KEY);
    }

    public static String getDefaultFiltersTooltip() {
        String tooltip = BrikitBandanaManager.getEntry(null, (String)DEFAULT_FILTERS_TOOLTIP);
        return BrikitString.isSet((String)tooltip) ? tooltip : Confluence.getText((String)DEFAULT_FILTERS_TOOLTIP_KEY);
    }

    public static String getMoreHelpLink() {
        return BrikitBandanaManager.getEntry(null, (String)MORE_SEARCH_HELP_LINK);
    }

    public static String getSearchMacroParameters() {
        return BrikitBandanaManager.getEntry(null, (String)SEARCH_MACRO_PARAMETERS);
    }

    public static BrikitList<String> getSearchMacroParametersList() {
        return BrikitString.splitCommaSeparated((String)TargetedSearch.getSearchMacroParameters());
    }

    public static boolean isLicensed(PluginLicenseManager pluginLicenseManager) {
        if (pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                return false;
            }
            return license.isActive();
        }
        return false;
    }

    public static void saveAllFiltersTooltip(String tooltip) {
        BrikitBandanaManager.saveEntry(null, (String)ALL_FILTERS_TOOLTIP, (Object)tooltip);
    }

    public static void saveAnyFiltersTooltip(String tooltip) {
        BrikitBandanaManager.saveEntry(null, (String)ANY_FILTERS_TOOLTIP, (Object)tooltip);
    }

    public static void saveDefaultFiltersTooltip(String tooltip) {
        BrikitBandanaManager.saveEntry(null, (String)DEFAULT_FILTERS_TOOLTIP, (Object)tooltip);
    }

    public static void saveMoreHelpLink(String moreHelpLink) {
        BrikitBandanaManager.saveEntry(null, (String)MORE_SEARCH_HELP_LINK, (Object)moreHelpLink);
    }

    public static void saveSearchMacroParameters(String searchMacroParameters) {
        BrikitBandanaManager.saveEntry(null, (String)SEARCH_MACRO_PARAMETERS, (Object)searchMacroParameters);
    }

    public static void saveTaxonomyEditorUserGroups(List<String> usergroups) {
        BrikitBandanaManager.saveEntry(null, (String)TAXONOMY_EDITOR_USER_GROUPS, (Object)new BrikitList(usergroups).join(DELIMITER));
    }

    public static List<String> taxonomyEditorUserGroups() {
        return BrikitString.split((String)BrikitBandanaManager.getEntry(null, (String)TAXONOMY_EDITOR_USER_GROUPS), (String)DELIMITER);
    }
}

