/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.audit.api.AuditService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.AuditLog;
import com.brikit.targetedsearch.model.CascadingLabel;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class CascadingLabelsAction
extends AbstractTargetedSearchAction {
    protected String labels;
    @ComponentImport
    protected AuditService auditService;

    @PermittedMethods(value={HttpMethod.POST})
    public String add() {
        CascadingLabel.addCascadingLabelToPage(this.getPage(), this.getLabels());
        this.addAuditLogEntry();
        return this.jsonSuccess();
    }

    protected void addAuditLogEntry() {
        try {
            AuditLog auditLog = new AuditLog();
            auditLog.setAuditService(this.getAuditService());
            auditLog.addEntry(this.getPage(), "cascading label(s) added", BrikitString.split((String)this.getLabels(), (String)" ").join(", "), "", "Cascading labels", "Cascading label(s) added");
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Failed to create audit log entry for cascading labels (" + this.getLabels() + ") on " + String.valueOf(this.getPage())), (Exception)ex);
        }
    }

    public AuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public String getLabels() {
        return this.labels;
    }

    @StrutsParameter
    public void setLabels(String labels) {
        this.labels = labels;
    }

    public void validate() {
        super.validate();
        if (!CascadingLabel.canCascadeLabels(this.getSpaceKey())) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

