/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.macros;

import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.ThemePressAwareness;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AbstractFacetAwareMacro
extends BrikitNoBodyMacro {
    protected static final String SEARCH_SCOPE_KEY = "search-scope";
    protected static final String SPACE_SEARCH_SCOPE_KEY = "space-search-scope";
    protected static final String SHOW_SPACE_CATEGORIES_KEY = "show-space-categories";
    protected static final String MAX_RESULTS_KEY = "max-results";
    protected static final String HIDE_GROUPS_KEY = "hide-groups";
    protected static final String SHOW_GROUPS_KEY = "show-groups";
    protected static final String SIMPLE_FILTER_LIST_KEY = "simple-filter-list";
    protected static final String SEARCH_FILTER_LABELS_KEY = "include-filters";
    protected static final String SEARCH_FILTERS_KEY = "search-filters";
    protected static final String ADDITIONAL_FILTERS_KEY = "additional-filters";
    protected static final String EXCLUDE_LABELS_KEY = "exclude-labels";
    protected static final String SEARCH_PAGES_KEY = "search-pages";
    protected static final String SEARCH_BLOGPOSTS_KEY = "search-blogposts";
    protected static final String SEARCH_ATTACHMENTS_KEY = "search-attachments";
    protected static final String LAST_MODIFIED_KEY = "last-modified";
    protected static final String SEARCH_FILTERS = "searchFilters";
    protected static final String EXCLUDE_LABELS = "excludeLabels";
    protected static final String EXCLUDE_FILTERS = "excludeFilters";
    protected static final String SEARCH_SCOPE = "searchScope";
    protected static final String SPACE_SEARCH_SCOPE = "spaceSearchScope";
    protected static final String SEARCH_PAGES = "searchPages";
    protected static final String SEARCH_BLOGPOSTS = "searchBlogposts";
    protected static final String SEARCH_ATTACHMENTS = "searchAttachments";
    protected static final String LAST_MODIFIED = "lastModified";
    protected static final String HOST_SPACE_KEY = "hostSpaceKey";
    protected static final String SHOW_SPACE_CATEGORIES = "showSpaceCategories";
    protected static final String CURRENT_SPACE_TOKEN = "@current";
    protected static final String CURRENT_SPACE_CATEGORIES_TOKEN = "@currentCategories";
    protected static final String ERROR_INVALID_FILTER = "com.brikit.targetedsearch.macros.validation.invalid.filter";
    protected static final String ERROR_DETAIL_FILTERS_PARAM = "com.brikit.targetedsearch.targeted-search-link.param.include-filters.label";
    protected static final String ERROR_NO_FILTER_GROUPS_VISIBLE = "com.brikit.targetedsearch.macros.no.filters.or.group.visible";
    protected static final String ERROR_INVALID_FILTER_GROUP_NAME = "com.brikit.targetedsearch.macros.validation.invalid.filter.group";

    protected List<String> convertUserInputToLabels(List<String> userInput, boolean validating) throws MacroExecutionException {
        ArrayList<String> inputAsLabels = new ArrayList<String>();
        for (String userValue : userInput) {
            if (Filter.getFilterByLabel(userValue) != null) {
                inputAsLabels.add(userValue);
                continue;
            }
            Filter found = Filter.getFilterByName(userValue);
            if (found != null) {
                inputAsLabels.add(found.getLabel());
                continue;
            }
            if (validating) {
                throw new MacroExecutionException(this.getInvalidFilterMessage(userValue));
            }
            inputAsLabels.add(userValue);
        }
        return inputAsLabels;
    }

    protected String getCurrentSpaceKey(BrikitMacroContext macroContext) {
        return macroContext.getSpace() == null ? null : macroContext.getSpace().getKey();
    }

    public List<Filter> getExcludeFilters(BrikitMacroContext macroContext) throws MacroExecutionException {
        return Filter.getFiltersForLabels(this.getExcludeLabels(macroContext));
    }

    public List<String> getExcludeLabels(BrikitMacroContext macroContext) throws MacroExecutionException {
        List userInput = macroContext.commaSeparatedListValue(EXCLUDE_LABELS_KEY);
        return this.convertUserInputToLabels(userInput, false);
    }

    protected List<String> getHideGroups(BrikitMacroContext macroContext) {
        return macroContext.commaSeparatedListValue(HIDE_GROUPS_KEY);
    }

    protected List<String> getSearchScope(BrikitMacroContext macroContext) {
        if (CURRENT_SPACE_CATEGORIES_TOKEN.equalsIgnoreCase(macroContext.stringValue(SEARCH_SCOPE_KEY)) && !ThemePressAwareness.isArchitectSpace(this.getCurrentSpaceKey(macroContext))) {
            Space currentSpace = macroContext.getSpace();
            return Confluence.getLabelNames((Space)currentSpace);
        }
        BrikitList categories = new BrikitList();
        for (String possibleCategory : macroContext.listValue(SEARCH_SCOPE_KEY)) {
            if (Confluence.isSpace((String)possibleCategory)) continue;
            categories.add((Object)possibleCategory);
        }
        return categories;
    }

    protected List<String> getSpaceSearchScope(BrikitMacroContext macroContext) {
        String searchScopeValue = macroContext.stringValue(SEARCH_SCOPE_KEY);
        String spaceSearchScopeValue = macroContext.stringValue(SPACE_SEARCH_SCOPE_KEY);
        if (!BrikitString.isSet((String)spaceSearchScopeValue) && BrikitString.isSet((String)searchScopeValue)) {
            spaceSearchScopeValue = searchScopeValue;
        }
        if (CURRENT_SPACE_TOKEN.equalsIgnoreCase(spaceSearchScopeValue) && !ThemePressAwareness.isArchitectSpace(this.getCurrentSpaceKey(macroContext))) {
            String currentSpaceKey = this.getCurrentSpaceKey(macroContext);
            ArrayList<String> keys = new ArrayList<String>(1);
            keys.add(currentSpaceKey);
            return keys;
        }
        ArrayList<String> keys = new ArrayList<String>();
        if (BrikitString.isSet((String)spaceSearchScopeValue)) {
            for (String possibleKey : BrikitString.splitCommaOrSpaceSeparated((String)spaceSearchScopeValue)) {
                if (!Confluence.isSpace((String)possibleKey)) continue;
                keys.add(possibleKey);
            }
        }
        return keys;
    }

    protected List<String> getShowGroups(BrikitMacroContext macroContext) {
        return macroContext.commaSeparatedListValue(SHOW_GROUPS_KEY);
    }

    public boolean getShowSpaceCategories(BrikitMacroContext macroContext) {
        return macroContext.booleanValue(SHOW_SPACE_CATEGORIES_KEY);
    }

    public List<FilterGroup> getFilterGroups(BrikitMacroContext macroContext) {
        return FilterGroup.getFilterGroupsForSpace(macroContext.getSpace());
    }

    protected String getInvalidFilterMessage(String userInput) {
        List<String> substitutions = Arrays.asList(userInput, Confluence.getText((String)ERROR_DETAIL_FILTERS_PARAM));
        return Confluence.getText((String)ERROR_INVALID_FILTER, substitutions);
    }

    public String getLastModified(BrikitMacroContext macroContext) {
        return macroContext.stringValue(LAST_MODIFIED_KEY);
    }

    protected int getMaxResults(BrikitMacroContext macroContext) {
        return macroContext.integerValue(MAX_RESULTS_KEY, 200);
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public List<Filter> getAdditionalFilters(BrikitMacroContext macroContext) throws MacroExecutionException {
        List userInput = macroContext.commaSeparatedListValue(ADDITIONAL_FILTERS_KEY);
        return Filter.getFiltersForLabels(this.convertUserInputToLabels(userInput, false));
    }

    public boolean getSearchAttachments(BrikitMacroContext macroContext) {
        return macroContext.booleanValue(SEARCH_ATTACHMENTS_KEY);
    }

    public boolean getSearchBlogPosts(BrikitMacroContext macroContext) {
        return macroContext.booleanValue(SEARCH_BLOGPOSTS_KEY);
    }

    public List<Filter> getSearchFilters(BrikitMacroContext macroContext) throws MacroExecutionException {
        return Filter.getFiltersForLabels(this.getSearchFilterLabels(macroContext));
    }

    public List<String> getSearchFilterLabels(BrikitMacroContext macroContext) throws MacroExecutionException {
        List userInput = macroContext.commaSeparatedListValue(SEARCH_FILTER_LABELS_KEY);
        return this.convertUserInputToLabels(userInput, true);
    }

    public boolean getSearchPages(BrikitMacroContext macroContext) {
        return macroContext.booleanValue(SEARCH_PAGES_KEY);
    }

    public List<Filter> getSimpleFilterList(BrikitMacroContext macroContext) throws MacroExecutionException {
        List userInput = macroContext.commaSeparatedListValue(SIMPLE_FILTER_LIST_KEY);
        return Filter.getFiltersForLabels(this.convertUserInputToLabels(userInput, false));
    }

    protected String getWidth(BrikitMacroContext macroContext) {
        return macroContext.stringValue("width");
    }

    protected void initializeVelocityContext(BrikitMacroContext macroContext) throws MacroExecutionException {
        macroContext.velocityContextAdd((Object)"width", (Object)this.getWidth(macroContext));
        macroContext.velocityContextAdd((Object)MAX_RESULTS_KEY, (Object)this.getMaxResults(macroContext));
        macroContext.velocityContextAdd((Object)HOST_SPACE_KEY, (Object)this.getCurrentSpaceKey(macroContext));
        macroContext.velocityContextAdd((Object)SHOW_SPACE_CATEGORIES, (Object)this.getShowSpaceCategories(macroContext));
        macroContext.velocityContextAdd((Object)SHOW_GROUPS_KEY, this.getShowGroups(macroContext));
        macroContext.velocityContextAdd((Object)SIMPLE_FILTER_LIST_KEY, this.getSimpleFilterList(macroContext));
        macroContext.velocityContextAdd((Object)HIDE_GROUPS_KEY, this.getHideGroups(macroContext));
        macroContext.velocityContextAdd((Object)SEARCH_SCOPE, this.getSearchScope(macroContext));
        macroContext.velocityContextAdd((Object)SPACE_SEARCH_SCOPE, this.getSpaceSearchScope(macroContext));
        macroContext.velocityContextAdd((Object)SEARCH_FILTER_LABELS_KEY, this.getSearchFilterLabels(macroContext));
        macroContext.velocityContextAdd((Object)SEARCH_FILTERS, this.getSearchFilters(macroContext));
        macroContext.velocityContextAdd((Object)ADDITIONAL_FILTERS_KEY, this.getAdditionalFilters(macroContext));
        macroContext.velocityContextAdd((Object)EXCLUDE_LABELS, this.getExcludeLabels(macroContext));
        macroContext.velocityContextAdd((Object)EXCLUDE_FILTERS, this.getExcludeFilters(macroContext));
        macroContext.velocityContextAdd((Object)SEARCH_ATTACHMENTS, (Object)this.getSearchAttachments(macroContext));
        macroContext.velocityContextAdd((Object)SEARCH_BLOGPOSTS, (Object)this.getSearchBlogPosts(macroContext));
        macroContext.velocityContextAdd((Object)SEARCH_PAGES, (Object)this.getSearchPages(macroContext));
        macroContext.velocityContextAdd((Object)LAST_MODIFIED, (Object)this.getLastModified(macroContext));
    }

    public List<String> sortKeys(Map<String, String> aMap) {
        return new BrikitMap(aMap).sortedKeys();
    }

    public void validateFilterGroups(BrikitMacroContext macroContext) throws MacroExecutionException {
        if (FilterGroup.getFilterGroups().isEmpty()) {
            return;
        }
        List<FilterGroup> filterGroupsForSpace = FilterGroup.getFilterGroupsForSpace(macroContext.getSpace());
        ArrayList<String> invalidNames = new ArrayList<String>();
        ArrayList<String> availableGroups = new ArrayList<String>();
        for (FilterGroup filterGroup : filterGroupsForSpace) {
            String lowercaseName = filterGroup.getDisplayName().toLowerCase();
            if (availableGroups.contains(lowercaseName)) continue;
            availableGroups.add(lowercaseName);
        }
        List<String> specifiedGroups = this.getShowGroups(macroContext);
        specifiedGroups.addAll(this.getHideGroups(macroContext));
        for (String filterGroupName : specifiedGroups) {
            FilterGroup filterGroup = FilterGroup.getFilterGroupByName(filterGroupName);
            if (filterGroup == null) {
                invalidNames.add(filterGroupName);
                continue;
            }
            if (availableGroups.contains(filterGroupName.toLowerCase())) continue;
            invalidNames.add(filterGroupName);
        }
        if (!invalidNames.isEmpty()) {
            String string = Confluence.getText((String)ERROR_INVALID_FILTER_GROUP_NAME, Arrays.asList(new BrikitList(invalidNames).join(", ")));
            throw new MacroExecutionException(string);
        }
    }

    public void validateVisibleFilterGroups(BrikitMacroContext macroContext) throws MacroExecutionException {
        List<FilterGroup> filterGroupsForSpace = FilterGroup.getFilterGroupsForSpace(macroContext.getSpace());
        if (filterGroupsForSpace.isEmpty()) {
            throw new MacroExecutionException(Confluence.getText((String)ERROR_NO_FILTER_GROUPS_VISIBLE));
        }
    }
}

