/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.extractor;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.targetedsearch.model.CascadingLabel;
import com.brikit.targetedsearch.model.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class CascadingLabelExtractor
implements Extractor2 {
    public static final String LABEL_FIELD = "label";
    public static final String CASCADING_LABEL_FIELD_NAME = "cascadingLabel";
    protected static ConfluenceUser adminUser;
    protected static long adminUserTimestamp;
    protected static final StringBuilder EMPTY_STRING_BUILDER;

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        if (!(searchable instanceof Page)) {
            return fieldDescriptors;
        }
        ConfluenceUser indexerUser = Confluence.getConfluenceUser();
        long now = new Date().getTime();
        if (now - adminUserTimestamp > 600000L) {
            adminUser = Confluence.findAnyConfluenceAdministrator();
            if (adminUser == null) {
                BrikitLog.logError((String)"Unable to find a Confluence Administrator account, so cascading labels may not be added to the Confluence search index.");
            }
            adminUserTimestamp = now;
        }
        AuthenticatedUserThreadLocal.set((ConfluenceUser)adminUser);
        Page page = (Page)searchable;
        BrikitLog.logDebug((String)("Indexing for: " + searchable + " with cascading labels: " + CascadingLabel.cascadingLabelsForPage((AbstractPage)page) + " with user " + Confluence.getConfluenceUser()));
        for (String label : CascadingLabel.cascadingLabelsForPage((AbstractPage)page)) {
            BrikitLog.logDebug((String)("Adding cascading label '" + label + "' to index for page: " + page));
            FieldDescriptor fieldDescriptor = new FieldDescriptor(CASCADING_LABEL_FIELD_NAME, label, FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED);
            fieldDescriptors.add(fieldDescriptor);
        }
        BrikitList<Filter> inheritedFilters = CascadingLabel.inheritedLabelsForPage((AbstractPage)page);
        if (!inheritedFilters.isEmpty()) {
            for (Filter filter : inheritedFilters) {
                Label label = Confluence.getLabel((String)filter.getLabel());
                BrikitLog.logDebug((String)("Adding inherited label '" + label.getName() + "' to index for page: " + page));
                if (label == null) continue;
                FieldDescriptor fieldDescriptor = new FieldDescriptor(LABEL_FIELD, label.toStringWithNamespace(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED);
                fieldDescriptors.add(fieldDescriptor);
            }
        }
        AuthenticatedUserThreadLocal.set((ConfluenceUser)indexerUser);
        return fieldDescriptors;
    }

    public StringBuilder extractText(Object searchable) {
        if (!(searchable instanceof Page)) {
            return EMPTY_STRING_BUILDER;
        }
        StringBuilder builder = new StringBuilder();
        BrikitList searchText = new BrikitList();
        for (Filter filter : CascadingLabel.inheritedLabelsForPage((AbstractPage)((Page)searchable))) {
            searchText.add((Object)filter.getLabel());
        }
        builder.append(searchText.join(" "));
        return builder;
    }

    static {
        adminUserTimestamp = 0L;
        EMPTY_STRING_BUILDER = new StringBuilder(0);
    }
}

