/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.brikit.core.confluence.BrikitBandanaManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.model.Filter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CascadingLabel {
    protected static final String CASCADING_LABELS = "cascadingLabels";
    protected static final String CASCADING_LABEL_USER_GROUPS = "cascadingLabelUserGroups";
    protected static final String DELIMITER = ",";

    public static void addCascadingLabelToPage(AbstractPage page, String labelString) {
        if (!(page instanceof Page)) {
            return;
        }
        HashSet<String> labels = new HashSet<String>();
        labels.addAll(CascadingLabel.cascadingLabelsForPage(page));
        labels.addAll(BrikitString.split(labelString));
        BrikitList<String> labelList = new BrikitList<String>((Set<String>)labels);
        CascadingLabel.saveCascadingLabels(page, labelList);
    }

    public static boolean canCascadeLabels(String spaceKey) {
        return Confluence.canAdministerSpace(spaceKey) || Confluence.isGroupMember(CascadingLabel.userGroupsWithCascadePermission());
    }

    public static BrikitList<Filter> cascadingFiltersForPage(AbstractPage page) {
        BrikitList<Filter> filters = new BrikitList<Filter>();
        for (String label : CascadingLabel.cascadingLabelsForPage(page)) {
            Filter filter = Filter.getFilterByLabel(label);
            if (filter == null) continue;
            filters.add(filter);
        }
        return filters;
    }

    public static void cascadingLabelsChangedOnPage(AbstractPage page, List<String> labels) {
        if (!(page instanceof Page)) {
            return;
        }
        for (String label : labels) {
            CascadingLabel.labelAddedToPage(page, label);
        }
    }

    public static BrikitList<String> cascadingLabelsForPage(AbstractPage page) {
        return Confluence.getContentPropertyList((ContentEntityObject)page, CASCADING_LABELS);
    }

    protected static void convertCascadingLabelsMetaData(AbstractPage page) {
        if (!(page instanceof Page)) {
            return;
        }
        String metadata = Confluence.getMetaData((ContentEntityObject)page, CASCADING_LABELS);
        if (!BrikitString.isSet(metadata)) {
            return;
        }
        Confluence.saveContentProperty((ContentEntityObject)page, CASCADING_LABELS, BrikitString.split(metadata, DELIMITER));
        Confluence.removeMetaData((ContentEntityObject)page, CASCADING_LABELS);
    }

    public static boolean hasCascadingLabelsForPage(AbstractPage page) {
        return !CascadingLabel.cascadingLabelsForPage(page).isEmpty();
    }

    public static BrikitList<Filter> inheritedLabelsForPage(AbstractPage page) {
        BrikitList<Filter> filters = new BrikitList<Filter>();
        if (!(page instanceof Page)) {
            return filters;
        }
        for (Page ancestor : Confluence.getAncestors(page)) {
            if (ancestor.equals((Object)page)) continue;
            filters.addAll(CascadingLabel.cascadingFiltersForPage((AbstractPage)ancestor));
        }
        return filters;
    }

    public static void labelAddedToPage(AbstractPage page, String label) {
        if (!(page instanceof Page)) {
            return;
        }
        if (CascadingLabel.cascadingLabelsForPage(page).contains(label)) {
            AddPageToIndexerRunnable thread = new AddPageToIndexerRunnable((Page)page);
            new Thread(thread).start();
        }
    }

    public static void labelRemovedFromPage(AbstractPage page, String label) {
        if (!(page instanceof Page)) {
            return;
        }
        if (CascadingLabel.cascadingLabelsForPage(page).contains(label)) {
            CascadingLabel.removeCascadingLabelFromPage(page, label);
            AddPageToIndexerRunnable thread = new AddPageToIndexerRunnable((Page)page);
            new Thread(thread).start();
        }
    }

    public static void removeCascadingLabelFromPage(AbstractPage page, String label) {
        if (!(page instanceof Page)) {
            return;
        }
        BrikitList<String> labels = CascadingLabel.cascadingLabelsForPage(page);
        while (labels.contains(label)) {
            labels.remove(label);
        }
        CascadingLabel.saveCascadingLabels(page, labels);
    }

    public static void saveCascadingLabels(AbstractPage page, BrikitList<String> labels) {
        Confluence.saveContentProperty((ContentEntityObject)page, CASCADING_LABELS, labels);
        CascadingLabel.cascadingLabelsChangedOnPage(page, labels);
    }

    public static void saveUserGroupsWithCascadePermission(List<String> usergroups) {
        BrikitBandanaManager.saveEntry(null, CASCADING_LABEL_USER_GROUPS, new BrikitList<String>(usergroups).join(DELIMITER));
    }

    public static List<String> userGroupsWithCascadePermission() {
        return BrikitString.split(BrikitBandanaManager.getEntry(null, CASCADING_LABEL_USER_GROUPS), DELIMITER);
    }

    protected static class AddPageToIndexerRunnable
    implements Runnable {
        protected Page page;

        public AddPageToIndexerRunnable(Page page) {
            this.page = page;
        }

        @Override
        public void run() {
            for (Page descendant : Confluence.getDescendants(this.page)) {
                Confluence.addAbstractPageToIndexQueueForUpdate((AbstractPage)descendant, false);
            }
        }
    }
}

