/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.like.Like;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.SpaceCategoryQuery;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.core.bean.EntityObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.search.ContentSearch;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.pinboards.cache.PinboardFeedCache;
import com.brikit.pinboards.cache.RenderedContentCache;
import com.brikit.pinboards.model.FeedEntry;
import com.brikit.pinboards.model.LastModifiedSortOrder;
import com.brikit.pinboards.model.LikeWrapper;
import com.brikit.pinboards.model.Pinboard;
import com.brikit.pinboards.model.Share;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PinboardFeed {
    public static final String PAGE_TYPE = "page";
    public static final String BLOGPOST_TYPE = "blogpost";
    public static final String ATTACHMENT_TYPE = "attachment";
    public static final String SOCIAL_ACTIVITY_TYPE = "social";
    protected static Set<PinboardFeed> allFeeds;
    protected String labels;
    protected List<String> labelsList;
    protected boolean matchAllLabels;
    protected String excludeLabels;
    protected List<String> excludeLabelsList;
    protected boolean includePages;
    protected boolean includeBlogposts;
    protected boolean includeFiles;
    protected boolean includeSocial;
    protected String spaceFilter;
    protected String spaceKeysOrCategories;
    protected PinboardFeedCache cache;
    protected String cacheKey;
    protected ActiveObjects activeObjects;
    Set<String> fieldsToFetch;

    private PinboardFeed(String labels, boolean matchAllLabel, String excludeLabels, boolean includePages, boolean includeBlogposts, boolean includeFiles, boolean includeSocial, String spaceFilter, String spaceKeysOrCategories, String defaultSpaceKey, ActiveObjects activeObjects) {
        this.labels = labels;
        this.matchAllLabels = matchAllLabel;
        this.excludeLabels = excludeLabels;
        this.includePages = includePages;
        this.includeBlogposts = includeBlogposts;
        this.includeFiles = includeFiles;
        this.includeSocial = includeSocial;
        this.spaceFilter = spaceFilter;
        if ("specified keys".equals(this.getSpaceFilter()) && !BrikitString.isSet((String)spaceKeysOrCategories)) {
            spaceKeysOrCategories = defaultSpaceKey;
        }
        this.spaceKeysOrCategories = spaceKeysOrCategories;
        this.activeObjects = activeObjects;
    }

    public static synchronized PinboardFeed feedFor(String labels, boolean matchAllLabel, String excludeLabels, boolean includePages, boolean includeBlogposts, boolean includeFiles, boolean includeSocial, String spaceFilter, String spaceKeysOrCategories, String defaultSpaceKey, ActiveObjects activeObjects) {
        PinboardFeed newFeed = new PinboardFeed(labels, matchAllLabel, excludeLabels, includePages, includeBlogposts, includeFiles, includeSocial, spaceFilter, spaceKeysOrCategories, defaultSpaceKey, activeObjects);
        if (PinboardFeed.getAllFeeds().contains(newFeed)) {
            for (PinboardFeed feed : PinboardFeed.getAllFeeds()) {
                if (!feed.equals(newFeed)) continue;
                return feed;
            }
        }
        PinboardFeed.getAllFeeds().add(newFeed);
        return newFeed;
    }

    public boolean acceptsContentForSpace(Space aSpace) {
        if (aSpace == null) {
            return false;
        }
        return this.acceptsAllSpaces() || this.acceptsGlobalSpaces() && aSpace.isGlobal() || this.acceptsSpacesByCategory() && Confluence.spaceHasAnyCategory((String)aSpace.getKey(), this.getSpaceCategories()) || this.acceptsSpacesByKey() && this.getSpaceKeys().contains((Object)aSpace.getKey());
    }

    public boolean acceptsType(String type) {
        return PAGE_TYPE.equals(type) && this.isIncludePages() || BLOGPOST_TYPE.equals(type) && this.isIncludeBlogposts() || ATTACHMENT_TYPE.equals(type) && this.isIncludeFiles() || SOCIAL_ACTIVITY_TYPE.equals(type) && this.isIncludeSocial();
    }

    public boolean acceptsAllSpaces() {
        return "all spaces".equals(this.getSpaceFilter());
    }

    public boolean acceptsGlobalSpaces() {
        return "all global spaces".equals(this.getSpaceFilter());
    }

    public boolean acceptsSpacesByCategory() {
        return "specified categories".equals(this.getSpaceFilter());
    }

    public boolean acceptsSpacesByKey() {
        return "specified keys".equals(this.getSpaceFilter());
    }

    public static void addToFeeds(AbstractLabelableEntityObject labelable, String type) {
        PinboardFeed.addToFeeds(labelable, labelable, type);
    }

    public static void addToFeeds(AbstractLabelableEntityObject itemToAdd, AbstractLabelableEntityObject labelable, String type) {
        PinboardFeed.removeFromFeeds(itemToAdd);
        for (PinboardFeed feed : PinboardFeed.getFeedsAffecting(itemToAdd, labelable, type)) {
            try {
                feed.insertToCache(new FeedEntry((ConfluenceEntityObject)itemToAdd));
            }
            catch (IOException ex) {
                BrikitLog.logError((String)("Unable to add to Pinboard feed: " + String.valueOf(itemToAdd)), (Exception)ex);
            }
        }
    }

    public static void addToFeeds(LikeWrapper likeWrapper) {
        AbstractLabelableEntityObject likedObject = likeWrapper.getSubject();
        for (PinboardFeed feed : PinboardFeed.getFeedsAffecting(likedObject, SOCIAL_ACTIVITY_TYPE)) {
            try {
                feed.insertToCache(new FeedEntry(likeWrapper));
            }
            catch (IOException ex) {
                BrikitLog.logError((String)("Unable to add to Pinboard feed: " + String.valueOf(likeWrapper)), (Exception)ex);
            }
        }
    }

    public static void addToFeeds(Share share) {
        ContentEntityObject sharedObject = share.getContentEntity();
        for (PinboardFeed feed : PinboardFeed.getFeedsAffecting((AbstractLabelableEntityObject)sharedObject, SOCIAL_ACTIVITY_TYPE)) {
            try {
                feed.insertToCache(new FeedEntry(share));
            }
            catch (IOException ex) {
                BrikitLog.logError((String)("Unable to add to Pinboard feed: " + String.valueOf(share)), (Exception)ex);
            }
        }
    }

    public static Set<PinboardFeed> getAllFeeds() {
        if (allFeeds == null) {
            allFeeds = new HashSet<PinboardFeed>();
        }
        return allFeeds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PinboardFeed> getFeedsAffecting(AbstractLabelableEntityObject labelable, String type) {
        ArrayList<PinboardFeed> feeds = new ArrayList<PinboardFeed>();
        Class<PinboardFeed> clazz = PinboardFeed.class;
        synchronized (PinboardFeed.class) {
            ArrayList<PinboardFeed> feedsCopy = new ArrayList<PinboardFeed>(PinboardFeed.getAllFeeds());
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (PinboardFeed feed : feedsCopy) {
                if (!feed.belongsOnFeed(labelable, type)) continue;
                feeds.add(feed);
            }
            return feeds;
        }
    }

    public static List<PinboardFeed> getFeedsAffecting(AbstractLabelableEntityObject itemToAdd, AbstractLabelableEntityObject labelable, String type) {
        HashSet<PinboardFeed> feeds = new HashSet<PinboardFeed>();
        feeds.addAll(PinboardFeed.getFeedsAffecting(labelable, type));
        if (itemToAdd instanceof Comment) {
            feeds.addAll(PinboardFeed.getFeedsAffecting((AbstractLabelableEntityObject)((Comment)itemToAdd), SOCIAL_ACTIVITY_TYPE));
        }
        return new ArrayList<PinboardFeed>(feeds);
    }

    public static List<PinboardFeed> getFeedsUsingLabel(Label label) {
        ArrayList<PinboardFeed> feeds = new ArrayList<PinboardFeed>();
        for (PinboardFeed feed : PinboardFeed.getAllFeeds()) {
            if (!feed.usesLabel(label)) continue;
            feeds.add(feed);
        }
        return feeds;
    }

    public static void removeFromFeeds(AbstractLabelableEntityObject itemToRemove) {
        FeedEntry feedEntry = new FeedEntry((ConfluenceEntityObject)itemToRemove);
        PinboardFeed.removeFromFeeds(feedEntry);
        RenderedContentCache.removeFromCache(feedEntry);
    }

    public static void removeFromFeeds(FeedEntry feedEntry) {
        for (PinboardFeed feed : PinboardFeed.getAllFeeds()) {
            try {
                feed.removeFromCache(feedEntry);
            }
            catch (IOException ex) {
                BrikitLog.logError((String)("Unable to remove handle from Pinboard feed: " + String.valueOf(feedEntry)), (Exception)ex);
            }
        }
    }

    public static void removeFromFeeds(LikeWrapper likeWrapper) {
        PinboardFeed.removeFromFeeds(new FeedEntry(likeWrapper));
    }

    public static void resetAllFeeds() {
        for (PinboardFeed feed : PinboardFeed.getAllFeeds()) {
            feed.reset();
        }
    }

    public static void resetFeedsForEntity(AbstractLabelableEntityObject entity, String type) {
        for (PinboardFeed feed : PinboardFeed.getFeedsAffecting(entity, type)) {
            feed.reset();
        }
    }

    public static void resetFeedsForLabel(Label label) {
        for (PinboardFeed feed : PinboardFeed.getFeedsUsingLabel(label)) {
            feed.reset();
        }
    }

    protected void adjustAndCacheResults(List results) throws IOException {
        for (Object result : results) {
            FeedEntry feedEntry;
            if (result instanceof LikeWrapper) {
                LikeWrapper like = (LikeWrapper)result;
                feedEntry = new FeedEntry(like);
            } else if (result instanceof Share) {
                Share share = (Share)result;
                feedEntry = new FeedEntry(share);
            } else {
                ConfluenceEntityObject ceo = (ConfluenceEntityObject)result;
                feedEntry = new FeedEntry(ceo.getLastModificationDate(), Pinboard.getHandleStringFor(ceo));
            }
            this.getCache().append(feedEntry);
        }
    }

    public boolean belongsOnFeed(AbstractLabelableEntityObject labellable, String type) {
        if (!this.acceptsType(type)) {
            return false;
        }
        if (this.acceptsContentForSpace(Confluence.getSpace((AbstractLabelableEntityObject)labellable))) {
            return false;
        }
        if (this.getLabelsList().isEmpty()) {
            return true;
        }
        if (labellable instanceof Comment) {
            Comment comment = (Comment)labellable;
            while (comment.getParent() != null) {
                comment = comment.getParent();
            }
            for (String filename : this.extractReferencedFilenames(Confluence.getBodyAsString((ContentEntityObject)comment), Confluence.getPage((Comment)comment))) {
                Attachment attachment = Confluence.getAttachment((AbstractPage)Confluence.getPage((Comment)comment), (String)filename);
                if (!this.belongsOnFeed((AbstractLabelableEntityObject)attachment, SOCIAL_ACTIVITY_TYPE)) continue;
                return true;
            }
            labellable = Confluence.getPage((Comment)comment);
        }
        boolean noMatch = this.isMatchAllLabels() && !Confluence.hasAllLabels((AbstractLabelableEntityObject)labellable, this.getLabelsList()) || !this.isMatchAllLabels() && !Confluence.hasAnyLabel((AbstractLabelableEntityObject)labellable, this.getLabelsList()) || Confluence.hasAnyLabel((AbstractLabelableEntityObject)labellable, this.getExcludeLabelsList());
        return !noMatch;
    }

    public boolean equals(Object obj) {
        return obj instanceof PinboardFeed && this.getCacheKey().equals(((PinboardFeed)obj).getCacheKey());
    }

    protected List<String> extractReferencedFilenames(String storageFormat, AbstractPage pageContext) {
        ArrayList<String> filenames = new ArrayList<String>();
        try {
            for (MacroDefinition macro : MacroParser.extractMacrosFromStorageFormat((AbstractPage)pageContext, (String)storageFormat, (String)"attachment-reference", (String)ATTACHMENT_TYPE)) {
                filenames.add(MacroParser.getStringParameter((MacroDefinition)macro, (String)ATTACHMENT_TYPE));
            }
        }
        catch (XhtmlException ex) {
            BrikitLog.logError((String)"Failed to parse comment", (Exception)((Object)ex));
        }
        return filenames;
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public synchronized PinboardFeedCache getCache() {
        if (this.cache == null) {
            this.cache = PinboardFeedCache.get(this);
        }
        return this.cache;
    }

    public String getCacheKey() {
        if (this.cacheKey == null) {
            BrikitList elements = new BrikitList();
            elements.add((Object)this.getLabels());
            elements.add((Object)this.isMatchAllLabels());
            elements.add((Object)this.getExcludeLabels());
            elements.add((Object)this.isIncludePages());
            elements.add((Object)this.isIncludeBlogposts());
            elements.add((Object)this.isIncludeFiles());
            elements.add((Object)this.isIncludeSocial());
            elements.add((Object)this.getSpaceFilter());
            elements.add((Object)this.getSpaceKeysOrCategories());
            this.cacheKey = elements.join(":");
        }
        return this.cacheKey;
    }

    public String getExcludeLabels() {
        return this.excludeLabels;
    }

    public List<String> getExcludeLabelsList() {
        if (this.excludeLabelsList == null) {
            this.excludeLabelsList = BrikitString.splitCommaSeparated((String)this.getExcludeLabels());
        }
        return this.excludeLabelsList;
    }

    protected Set<String> getFieldsToFetch() {
        if (this.fieldsToFetch == null) {
            this.fieldsToFetch = new HashSet<String>();
            this.fieldsToFetch.add(SearchFieldMappings.HANDLE.getName());
            this.fieldsToFetch.add(SearchFieldMappings.CONTENT_VERSION.getName());
            this.fieldsToFetch.add(SearchFieldMappings.SPACE_KEY.getName());
            this.fieldsToFetch.add(SearchFieldMappings.SPACE_NAME.getName());
            this.fieldsToFetch.add(SearchFieldMappings.TITLE.getName());
            this.fieldsToFetch.add(SearchFieldMappings.CONTENT_URL_PATH.getName());
            this.fieldsToFetch.add(SearchFieldMappings.TYPE.getName());
            this.fieldsToFetch.add(SearchFieldMappings.LAST_MODIFICATION_DATE.getName());
            this.fieldsToFetch.add(SearchFieldMappings.LAST_MODIFIER.getName());
            this.fieldsToFetch.add(SearchFieldMappings.CREATION_DATE.getName());
            this.fieldsToFetch.add(SearchFieldMappings.CREATOR.getName());
        }
        return this.fieldsToFetch;
    }

    public String getLabels() {
        return this.labels;
    }

    public List<String> getLabelsList() {
        if (this.labelsList == null) {
            this.labelsList = BrikitString.splitCommaSeparated((String)this.getLabels());
        }
        return this.labelsList;
    }

    public synchronized List<FeedEntry> getNextBatch(FeedEntry lastEntry, int count) throws Exception {
        if (!this.getCache().hasEnough(lastEntry, count)) {
            this.loadMoreSearchResults(lastEntry, count);
        }
        return new ArrayList<FeedEntry>(this.getCache().getNextBatch(lastEntry, count));
    }

    public String getSpaceFilter() {
        return this.spaceFilter;
    }

    public BrikitList<String> getSpaceCategories() {
        return this.acceptsSpacesByCategory() ? BrikitString.splitCommaOrSpaceSeparated((String)this.getSpaceKeysOrCategories()) : new BrikitList();
    }

    public BrikitList<String> getSpaceKeys() {
        return this.acceptsSpacesByKey() ? BrikitString.splitCommaOrSpaceSeparated((String)this.getSpaceKeysOrCategories()) : new BrikitList();
    }

    public String getSpaceKeysOrCategories() {
        return this.spaceKeysOrCategories;
    }

    public int hashCode() {
        return this.getCacheKey().hashCode();
    }

    public synchronized void insertToCache(FeedEntry feedEntry) throws IOException {
        this.getCache().insert(feedEntry);
    }

    public boolean isIncludeBlogposts() {
        return this.includeBlogposts;
    }

    public boolean isIncludeFiles() {
        return this.includeFiles;
    }

    public boolean isIncludePages() {
        return this.includePages;
    }

    public boolean isIncludeSocial() {
        return this.includeSocial;
    }

    public boolean isMatchAllLabels() {
        return this.matchAllLabels;
    }

    public void loadMoreSearchResults(FeedEntry lastEntry, int maxResults) throws Exception {
        maxResults = Math.max(maxResults, 100);
        ConfluenceEntityObject lastViewed = lastEntry != null ? Confluence.getEntityFor((Handle)new HibernateHandle(lastEntry.getHandle())) : null;
        Date latestDate = lastViewed instanceof EntityObject ? ((EntityObject)lastViewed).getLastModificationDate() : new Date();
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        ArrayList<ContentTypeEnum> contentTypes = new ArrayList<ContentTypeEnum>();
        if (this.isIncludePages()) {
            contentTypes.add(ContentTypeEnum.PAGE);
        }
        if (this.isIncludeBlogposts()) {
            contentTypes.add(ContentTypeEnum.BLOG);
        }
        if (this.isIncludeFiles()) {
            contentTypes.add(ContentTypeEnum.ATTACHMENT);
        }
        SearchResults contentResults = ContentSearch.searchByDateAndLabel(this.getFieldsToFetch(), (SpaceCategoryQuery)ContentSearch.spaceCategoryQuery((String)this.getSpaceFilter()), (InSpaceQuery)ContentSearch.inSpaceQuery((String)this.getSpaceFilter(), (List)BrikitString.splitCommaSeparated((String)this.getSpaceKeysOrCategories())), (ContentTypeQuery)ContentSearch.contentTypeQuery(contentTypes), (DateRangeQuery)ContentSearch.dateRangeQuery(null, (Date)latestDate), (SearchQuery)ContentSearch.labelsQuery((List)BrikitString.splitCommaSeparated((String)this.getLabels()), (boolean)this.isMatchAllLabels(), (List)BrikitString.splitCommaSeparated((String)this.getExcludeLabels())), (Integer)0, (Integer)maxResults, (SearchSort)ContentSearch.searchSort((String)"most recent"));
        searchResults.addAll(contentResults.getAll());
        SearchResult earliestContent = (SearchResult)new BrikitList(contentResults.getAll()).last();
        if (earliestContent == null) {
            return;
        }
        Date earliestDate = earliestContent.getCreationDate();
        if (this.isIncludeSocial()) {
            contentTypes = new ArrayList();
            contentTypes.add(ContentTypeEnum.COMMENT);
            SearchResults commentResults = ContentSearch.searchByDate(this.getFieldsToFetch(), (SpaceCategoryQuery)ContentSearch.spaceCategoryQuery((String)this.getSpaceFilter()), (InSpaceQuery)ContentSearch.inSpaceQuery((String)this.getSpaceFilter(), (List)BrikitString.splitCommaSeparated((String)this.getSpaceKeysOrCategories())), (ContentTypeQuery)ContentSearch.contentTypeQuery(contentTypes), (DateRangeQuery)ContentSearch.dateRangeQuery((Date)earliestDate, (Date)latestDate), null, null, (SearchSort)ContentSearch.searchSort((String)"most recent"));
            for (SearchResult result : commentResults) {
                ConfluenceEntityObject entity = Confluence.getEntityFor((SearchResult)result);
                if (!(entity instanceof Comment) || !this.belongsOnFeed((AbstractLabelableEntityObject)Confluence.getPage((Comment)((Comment)entity)), SOCIAL_ACTIVITY_TYPE)) continue;
                searchResults.add(result);
            }
        }
        ArrayList<Object> results = new ArrayList<Object>();
        ArrayList<ContentEntityObject> likableObjects = new ArrayList<ContentEntityObject>();
        for (SearchResult searchResult : searchResults) {
            ConfluenceEntityObject ceo = Confluence.getEntityFor((Handle)searchResult.getHandle());
            results.add(ceo);
            if (!(ceo instanceof ContentEntityObject)) continue;
            likableObjects.add((ContentEntityObject)ceo);
        }
        if (this.isIncludeSocial()) {
            Map likes = Confluence.getLikeManager().getLikes(likableObjects);
            long earliestTime = earliestDate == null ? 0L : earliestDate.getTime();
            long latestTime = latestDate == null ? Long.MAX_VALUE : latestDate.getTime();
            for (List likeList : likes.values()) {
                for (Like like : likeList) {
                    if (like.getCreatedDate().getTime() < earliestTime || like.getCreatedDate().getTime() > latestTime) continue;
                    results.add(new LikeWrapper(like));
                }
            }
            List<Share> shares = Share.getSharesByTimestamp(this.getActiveObjects(), earliestTime, latestTime);
            for (Share share : shares) {
                ContentEntityObject ceo = share.getContentEntity();
                if (ceo instanceof Comment) {
                    ceo = Confluence.getPage((Comment)((Comment)ceo));
                }
                if (!Confluence.hasLabels((AbstractLabelableEntityObject)ceo, this.getLabelsList(), (boolean)this.isMatchAllLabels())) continue;
                results.add(share);
            }
        }
        Collections.sort(results, new LastModifiedSortOrder(true));
        this.adjustAndCacheResults(results);
    }

    public synchronized void removeFromCache(FeedEntry feedEntry) throws IOException {
        this.getCache().remove(feedEntry);
    }

    public synchronized void reset() {
        PinboardFeedCache.get(this).reset();
    }

    public boolean usesLabel(Label label) {
        return this.usesLabel(label.getName());
    }

    public boolean usesLabel(String labelString) {
        return this.getLabelsList().contains(labelString);
    }
}

