/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.cache;

import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.pinboards.model.FeedEntry;
import com.brikit.pinboards.model.PinboardFeed;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PinboardFeedCache {
    public static final String CACHE_DIR = "pinboard_cache";
    public static final String FEED_CACHE_DIR = "feeds";
    public static final String FEED_ENTRIES_FILE_NAME = "feed_entries.txt";
    protected static Map<String, PinboardFeedCache> pinboardFeeds;
    protected String cacheKey;
    protected File cacheLocation;
    protected List<FeedEntry> feedEntries;

    protected PinboardFeedCache(PinboardFeed pinboardFeed) {
        this.cacheKey = pinboardFeed.getCacheKey();
    }

    public static synchronized PinboardFeedCache get(PinboardFeed pinboardFeed) {
        String cacheKey = pinboardFeed.getCacheKey();
        PinboardFeedCache pinboardFeedCache = PinboardFeedCache.getPinboardFeeds().get(cacheKey);
        if (pinboardFeedCache == null) {
            pinboardFeedCache = new PinboardFeedCache(pinboardFeed);
            PinboardFeedCache.getPinboardFeeds().put(cacheKey, pinboardFeedCache);
        }
        return pinboardFeedCache;
    }

    protected static Map<String, PinboardFeedCache> getPinboardFeeds() {
        if (pinboardFeeds == null) {
            pinboardFeeds = new HashMap<String, PinboardFeedCache>();
        }
        return pinboardFeeds;
    }

    public synchronized void append(FeedEntry feedEntry) throws IOException {
        if (this.contains(feedEntry)) {
            return;
        }
        this.getFeedEntries().add(feedEntry);
        this.writeFeedEntries();
    }

    protected File cacheLocation() {
        if (this.cacheLocation == null) {
            this.cacheLocation = new File(BrikitFile.getBrikitFile((String)CACHE_DIR), FEED_CACHE_DIR);
            this.cacheLocation = new File(this.cacheLocation, Integer.toString(this.getCacheKey().hashCode()));
        }
        return this.cacheLocation;
    }

    public synchronized boolean contains(FeedEntry feedEntry) {
        return this.getFeedEntries().contains(feedEntry);
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public synchronized int getCacheSize() {
        return this.getFeedEntries().size();
    }

    protected File feedFile(String filename) {
        return new File(this.cacheLocation(), filename);
    }

    protected synchronized List<FeedEntry> getFeedEntries() {
        try {
            if (this.feedEntries == null) {
                this.feedEntries = new ArrayList<FeedEntry>();
                for (String line : BrikitFile.readFileUTF8Lines((File)this.getFeedEntriesFile())) {
                    this.feedEntries.add(FeedEntry.unpack(line));
                }
            }
        }
        catch (IOException ex) {
            BrikitLog.logError((String)"Unable to read pinboard feed cache.", (Exception)ex);
            this.feedEntries = new ArrayList<FeedEntry>();
        }
        return this.feedEntries;
    }

    protected File getFeedEntriesFile() {
        return this.feedFile(FEED_ENTRIES_FILE_NAME);
    }

    public synchronized List<FeedEntry> getNextBatch(FeedEntry lastEntry, int count) {
        int start = this.indexOf(lastEntry) + 1;
        return this.getFeedEntries().subList(start, Math.min(start + count, this.getCacheSize()));
    }

    public synchronized boolean hasEnough(FeedEntry lastEntry, int count) {
        return this.indexOf(lastEntry) + count <= this.getCacheSize();
    }

    protected synchronized int indexOf(FeedEntry feedEntry) {
        return this.getFeedEntries().indexOf(feedEntry);
    }

    public synchronized void insert(FeedEntry feedEntry) throws IOException {
        this.getFeedEntries().add(0, feedEntry);
        this.writeFeedEntries();
    }

    public synchronized void remove(FeedEntry feedEntry) throws IOException {
        this.getFeedEntries().remove(feedEntry);
        this.writeFeedEntries();
    }

    public synchronized void reset() {
        BrikitFile.removeFile((File)this.getFeedEntriesFile());
        this.feedEntries = null;
    }

    protected void writeFeedEntries() throws IOException {
        BrikitFile.ensurePathExists((File)this.cacheLocation());
        ArrayList<String> lines = new ArrayList<String>();
        for (FeedEntry feedEntry : this.getFeedEntries()) {
            if (feedEntry == null) continue;
            lines.add(feedEntry.pack());
        }
        BrikitFile.writeFileUTF8Lines(lines, (File)this.getFeedEntriesFile());
    }
}

