(function ($) {
	
	ContentFlowApproveDialog = function (trigger) {
		this.trigger = $(trigger);
		this.trigger.data("dialog", this);
		this.initialize();
	};
	
	Object.assign(ContentFlowApproveDialog.prototype, ContentFlowInlineDialog.prototype, {
		
		
		getDialogOptions: function () {
			var options = {
	           width: 650  };
			   
			return options;
			
		},

		getDialogUrl: function () {
			return "/plugins/contentflow/view.action?pageId=" + ContentFlow.getPageId();
		},
		
		getDialogUrlData: function () {
			return { };
		},
		
		initialize: function () {
			var self = this;
		},
	
		initializeDialog: function () {
			var self = this;
		
			self.stopWait();

			// ContentFlow.adjustToolbarButton();
			
			// Bind the remove link here, because it's not on my dialog
			$("#remove-workflow-link").click(function (e) { self.removeWorkflowFromPage(); });
			
			
			self.dialog
				// TODO:  DD: Move these two lines to Edit-dialog?
				.on("keyup.brikit-content-flow", 	"#flow-approval-comment", 			function (e) {self.checkCommentLength(e)}.bind(self))
				.on("click.brikit-content-flow", 	"#save-content-flow-button", 		function (e) { ContentFlow.saveWorkflow(e); })
				.on("click.brikit-content-flow", 	"#cancel-content-flow-button", 		function (e) { ContentFlow.cancelEdit(e); })
				
				.on("click.brikit-content-flow", 	".reviewer-list .userLogoLink", 	function () { return false; })

	        	.on("click.brikit-content-flow", 	"#approve-manage-approval-button", 	this.approveContent.bind(this))
	        	.on("click.brikit-content-flow", 	"#reject-manage-approval-button", 	this.rejectContent.bind(this))
				.on("click.brikit-content-flow", 	"#undo-approve-button", 			this.undoApproveContent.bind(this))
	        	.on("click.brikit-content-flow", 	"#undo-reject-button", 				this.undoRejectContent.bind(this))
				
				.on("click.brikit-content-flow", 	"#save-workflow-button", 			function (e) { ContentFlow.saveTemplate(e); })

				// TODO:  save-template functionality likely obsolete -- search and clean-up (from stable code)
				.on("click.brikit-content-flow", 	"#save-template-button", 			function (e) { ContentFlow.saveTemplate(e); })
				.on("click.brikit-content-flow", 	"#cancel-save-template-button", 	function (e) { self.refreshContentFlowHolder(e); })

				// TODO: obsolete?
				.on("click.brikit-content-flow", 	"#hide-templates-button", 			function (e) { self.refreshContentFlowHolder(e); })
				
				.on("click.brikit-content-flow", 	"#close-manage-approval-button", 	function (e) { self.close(e); });
				
		 	  // ContentFlow.initialize();

		},
		
		// validate and call approve
		approveContent: function (event) {
			event.preventDefault(); 
			
			if (!this.validateCommentLength()) return;
			
	        var comment = $("#flow-approval-comment", ContentFlow.currentDialog).val();
		
            const data = {
				spaceKey: ContentFlow.spaceKey,
				pageId: ContentFlow.pageId,
				comment: comment
			};
            ContentFlow.addToken(data);

			$(event.currentTarget).spin();
	        jQuery.ajax({
	            url: ContentFlow.contextPath + "/plugins/contentflow/approve.action",
				data: data,
                type: "POST",
	            success: function(response) {
	                location.reload(true);
	            },
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while approving.", errorThrown);
					$(event.currentTarget).spinStop();
	            }
	        });			
	    },
		
		// Return the approval comment count 
		approverCommentCount: function() {
	
			var $commentCount = $(this.dialog).find("#flow-approval-count").first();
			return $commentCount;
		},
		
		// Return the approval comment field
		approverCommentField: function(e) {
			
			var $commentField = $(this.dialog).find("#flow-approval-comment").first();
			return $commentField;
		},
		
		charactersRemaining: function (e) {
			
			var reviewerComment = this.approverCommentField(e).val();
			return this.maxCommentLength() - reviewerComment.length; 
		},
		
		checkCommentLength: function (e) {
			
		    var remaining = this.charactersRemaining(e);
			$(this.approverCommentCount()).html(remaining); 
		},
		
		// return the max reviewer comment length
		maxCommentLength: function (e) {
			// TODO:  Put this somewhere more visible
			return 255;
		},
		
		// Un-DRY-ish with apply-dialog. This will probably become a generic method taking the action call and optional data, so any dialog
		// can refresh from a given action 
		refreshContentFlowHolder: function () {
			var self = this;
		
			if (!self.dialog) return location.reload(true);

			self.showWait();

            const data = {
				pageId: ContentFlow.getPageId()
			};
            ContentFlow.addToken(data);
	        jQuery.ajax({
				// Unique URL needed here (don't use getDialogUrl)
	            url: ContentFlow.contextPath + "/plugins/contentflow/updatecontentflowdialog.action",
				data: data,
                type: "POST",
	            success: function(response) {
	                self.dialog.hide().empty().append(response).fadeIn();
					self.initializeDialog();
					self.isDirty = false;
	            },
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while refreshing.", errorThrown);
	            }
	        });
		},
		
		rejectContent: function (event) {
			event.preventDefault();

            var comment = $("#flow-approval-comment", ContentFlow.currentDialog).val();

			$(event.currentTarget).spin();
            const data = {
				spaceKey: ContentFlow.spaceKey,
				pageId: ContentFlow.pageId,
				comment: comment
			};
            ContentFlow.addToken(data);
            jQuery.ajax({
                url: ContentFlow.contextPath + "/plugins/contentflow/reject.action",
				data: data,
                type: "POST",
                success: function(response) {
                    location.reload(true);
                },
                error: function (xhRequest, textStatus, errorThrown) {
                    ContentFlow.alertError("An error occurred while rejecting.", errorThrown);
					$(event.currentTarget).spinStop();
                }
            });
        },
		
		removeWorkflowFromPage: function () {
			ContentFlow.Dialog2.confirm(ContentFlow.getText("com.brikit.contentflow.remove.workflow.from.page.confirmation"), 
								{title: ContentFlow.getText("com.brikit.contentflow.remove.workflow.title")}, function (dialog) {
                const data = {
					pageId: ContentFlow.pageId
				};
                ContentFlow.addToken(data);
                jQuery.ajax({
                    url: ContentFlow.contextPath + "/plugins/contentflow/remove.action",
					data: data,
                    type: "POST",
                    success: function(response) {
                        dialog.hide();
						ContentFlow.reloadBrowser();	
                    },
                    error: function (xhRequest, textStatus, errorThrown) {
                        ContentFlow.alertError("An error occurred while removing the workflow.", errorThrown);
						dialog.enable();
                    },
                });
			});

            return false;
        },
		
		undoApproveContent: function (event) {
			event.preventDefault();

			ContentFlow.Dialog2.confirm(ContentFlow.getText("com.brikit.contentflow.undo.approval.confirmation"), {title: ContentFlow.getText("com.brikit.contentflow.undo.approve.name")}, function (dialog) {
                const data = {
					pageId: ContentFlow.pageId
				};
                ContentFlow.addToken(data);
	            jQuery.ajax({
	                url: ContentFlow.contextPath + "/plugins/contentflow/undoapprove.action",
					data: data,
                    type: "POST",
		            success: function(response) {
		                location.reload(true);
		            },
	                error: function (xhRequest, textStatus, errorThrown) {
	                    ContentFlow.alertError("An error occurred while undoing the approval.", errorThrown);
						dialog.enable();
	                }
	            });
			});

            return false;
        },
		
		undoRejectContent: function (event) {
			event.preventDefault();

			ContentFlow.Dialog2.confirm(ContentFlow.getText("com.brikit.contentflow.undo.return.confirmation"), {title: ContentFlow.getText("com.brikit.contentflow.undo.return.name")}, function (dialog) {
                const data = {
					pageId: ContentFlow.pageId
				};
                ContentFlow.addToken(data);
	            jQuery.ajax({
	                url: ContentFlow.contextPath + "/plugins/contentflow/undoreject.action",
					data: data,
                    type: "POST",
	                success: function(response) {
		                location.reload(true);
	                },
	                error: function (xhRequest, textStatus, errorThrown) {
	                    ContentFlow.alertError("An error occurred while undoing the rejection.", errorThrown);
						dialog.enable();
	                }
	            });
			});
        },

		// Validate reviewer comment length
		validateCommentLength: function () {
		
			var $commentField = this.approverCommentField();
			
			if ($commentField.val().length > 255) {
				// TODO:  Move message to properties
				alert("Comment length limited to 255 characters");
				return false
			}
			
			return true;
		}
		
	});


	ContentFlow.toFinalize(function ($) {
	});

})(jQuery);
