(function ($) {
	
	ContentFlow.ContentOwner = {

		dialog: function (selector) {
			var $dialog = $("#content-owner-dialog");
			return selector ? $(selector, $dialog) : $dialog;
		},
		
		form: function (selector) {
			var $form = ContentFlow.ContentOwner.dialog("#content-owner-form");
			return selector ? $(selector, $form) : $form;
		},
		
		initialize: function(response) {
			var options = {
				title: ContentFlow.getText("com.brikit.contentflow.set.content.owner"),
				id: "content-owner-dialog",
				okButton: ContentFlow.getText("com.brikit.contentflow.save.name"),
				closeWithButtonOnly: true
			};

            ContentFlow.Dialog2.dialog(response, options, ContentFlow.ContentOwner.saveContentOwner);
			
			Confluence.Binder.autocompleteUserOrGroup();

            // Prevent hitting return from submitting the form
            ContentFlow.ContentOwner.form().submit(function () { return false} );
        },

		saveContentOwner: function (dialog) {
			ContentFlow.ContentOwner.dialog(".dialog-button-panel .button-panel-button").spin();
			
			var $form = ContentFlow.ContentOwner.form();
			$.ajax({
				url: $form.attr("action"),
				data: $form.serialize(),
				method: "POST",
				success: ContentFlow.reloadBrowser,
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while saving the owner.", errorThrown);
				}
			})
		},
		
		showDialog: function (event) {
			event.preventDefault();
	        jQuery.ajax({
	            url: $(this).attr("href"),
				data: {
					pageId: ContentFlow.pageId
				},
	            success: ContentFlow.ContentOwner.initialize,
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while loading the page owner panel.", errorThrown);
	            }
	        });
		}
		
	};
	
	ContentFlow.toInit(function ($) {
		$("#content-flow-set-content-owner").click(ContentFlow.ContentOwner.showDialog);
	});

})(jQuery);
