/*
	A superclass for ContentFlow dialogs.
	SEE, e.g.:  ContentFlowModalDialog, ContentFlowInlineDialog 
*/
(function ($) {
	
	ContentFlowDialog  = function () {};
	
	ContentFlowDialog.prototype = {
		
		dialog: false,
		trigger: false,
		
		cancelEdit: function () {
			var self = this;
			return self.confirmLosingChanges(function () { self.refreshContentFlowHolder(); });
		},
		
		close: function (e) {
			if (e) e.preventDefault();
			
			if (this.dialog) {
		        this.dialog.remove();
				this.dialog = false;
			}
	        return false;
		},
		
		confirmLosingChanges: function (callback) {
			var self = this;
		
			if (self.isDirty) {
				ContentFlow.Dialog2.confirm(ContentFlow.getText("com.brikit.contentflow.discard.workflow.edits.confirmation"), 
					{ title: ContentFlow.getText("com.brikit.contentflow.cancel.workflow.edits.title") },
					function (dialog) {
						dialog.hide();
						callback.call();
					}
				);
			}
			else callback.call();

			return false;
		}, 
		

		showWait: function () {
			$("span", this.trigger).spin();
		},
	
		stopWait: function () {
			$("span", this.trigger).spinStop();
		},
	
		updateTrigger: function (options) {
			// TODO: DD: replace reference with event/listener (brikit-core or theme-press provides mechanism)
			ContentFlow.controls.updateTrigger(this.trigger, options);
		}

	};

})(jQuery);