/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.contentflow.model.PageStatus;
import com.brikit.contentflow.model.ao.PageStatusContentEntityAO;
import com.brikit.contentflow.model.query.PageStatusContentEntityQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class PageStatusContentEntity
extends AbstractActiveObjectsModel {
    protected PageStatusContentEntityAO activeObject;
    protected PageStatus pageStatus;

    public PageStatusContentEntity(ActiveObjects activeObjects, PageStatusContentEntityAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static PageStatusContentEntity create(ActiveObjects activeObjects, AbstractPage abstractPage, PageStatus pageStatus) {
        return abstractPage == null ? null : PageStatusContentEntity.create(activeObjects, abstractPage.getId(), pageStatus);
    }

    public static PageStatusContentEntity create(ActiveObjects activeObjects, long pageId, PageStatus pageStatus) {
        if (pageStatus == null || pageId == 0L) {
            return null;
        }
        String spaceKey = Confluence.getSpaceKey((long)pageId);
        PageStatusContentEntityAO pageStatusContentEntityAO = (PageStatusContentEntityAO)activeObjects.create(PageStatusContentEntityAO.class, new DBParam[0]);
        pageStatusContentEntityAO.setCeoId(pageId);
        pageStatusContentEntityAO.setPageStatusAO(pageStatus.getActiveObject());
        PageStatusContentEntity pageStatusContentEntity = new PageStatusContentEntity(activeObjects, pageStatusContentEntityAO);
        pageStatusContentEntity.save();
        return pageStatusContentEntity;
    }

    protected static List<PageStatusContentEntity> fromActiveObjects(ActiveObjects activeObjects, PageStatusContentEntityAO[] pageStatusContentEntityAOs) {
        ArrayList<PageStatusContentEntity> pageWorkflows = new ArrayList<PageStatusContentEntity>(pageStatusContentEntityAOs.length);
        for (PageStatusContentEntityAO pageWorkflowAO : pageStatusContentEntityAOs) {
            pageWorkflows.add(new PageStatusContentEntity(activeObjects, pageWorkflowAO));
        }
        return pageWorkflows;
    }

    public static PageStatusContentEntity getPageStatusContentEntity(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return abstractPage == null ? null : PageStatusContentEntity.getPageStatusContentEntity(activeObjects, abstractPage.getId());
    }

    public static PageStatusContentEntity getPageStatusContentEntity(ActiveObjects activeObjects, long pageId) {
        PageStatusContentEntityAO pageStatusContentEntityAO = PageStatusContentEntity.getPageStatusContentEntityAO(activeObjects, pageId);
        return pageStatusContentEntityAO == null ? null : new PageStatusContentEntity(activeObjects, pageStatusContentEntityAO);
    }

    public static PageStatusContentEntityAO getPageStatusContentEntityAO(ActiveObjects activeObjects, long pageId) {
        PageStatusContentEntityQuery query = new PageStatusContentEntityQuery(activeObjects);
        return query.getPageStatusContentEntityForPage(pageId);
    }

    public static PageStatusContentEntity getPageWorkflow(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return PageStatusContentEntity.getPageStatusContentEntity(activeObjects, abstractPage.getId());
    }

    public static PageStatusContentEntity getPageWorkflow(ActiveObjects activeObjects, String pageIdString) {
        return PageStatusContentEntity.getPageStatusContentEntity(activeObjects, BrikitNumber.parseInteger((String)pageIdString));
    }

    public static boolean hasPageStatus(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return abstractPage == null ? false : PageStatusContentEntity.hasPageStatus(activeObjects, abstractPage.getId());
    }

    public static boolean hasPageStatus(ActiveObjects activeObjects, long pageId) {
        PageStatusContentEntity pageStatusContentEntity = PageStatusContentEntity.getPageStatusContentEntity(activeObjects, pageId);
        return pageStatusContentEntity != null;
    }

    public static boolean isInUse(ActiveObjects activeObjects, PageStatus pageStatus) {
        if (pageStatus == null) {
            return false;
        }
        PageStatusContentEntityQuery query = new PageStatusContentEntityQuery(activeObjects);
        return query.getPageStatusContentEntitiesForPageStatus(pageStatus).length > 0;
    }

    public static PageStatusContentEntity setPageStatus(ActiveObjects activeObjects, AbstractPage abstractPage, PageStatus status) {
        return abstractPage == null ? null : PageStatusContentEntity.setPageStatus(activeObjects, abstractPage.getId(), status);
    }

    public static PageStatusContentEntity setPageStatus(ActiveObjects activeObjects, long pageId, PageStatus status) {
        String newLabel;
        String oldLabel;
        PageStatusContentEntity pageStatusContentEntity = PageStatusContentEntity.getPageStatusContentEntity(activeObjects, pageId);
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((long)pageId);
        if (abstractPage == null) {
            BrikitLog.logDebug((String)("Attempted to change page status on a page id for which no page exists: " + pageId));
            return null;
        }
        if (pageStatusContentEntity != null && BrikitString.isSet((String)(oldLabel = pageStatusContentEntity.getPageStatusLabel()))) {
            Confluence.removeLabel((String)oldLabel, (AbstractPage)abstractPage);
        }
        if (pageStatusContentEntity == null) {
            pageStatusContentEntity = PageStatusContentEntity.create(activeObjects, pageId, status);
        } else if (status != null) {
            pageStatusContentEntity.setPageStatus(status);
            pageStatusContentEntity.save();
        } else {
            pageStatusContentEntity.delete();
        }
        if (status != null && BrikitString.isSet((String)(newLabel = status.getLabel()))) {
            Confluence.addLabel((String)newLabel, (AbstractPage)abstractPage);
        }
        return pageStatusContentEntity;
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost((long)this.getPageId());
    }

    public PageStatusContentEntityAO getActiveObject() {
        return this.activeObject;
    }

    public int getID() {
        return this.getActiveObject().getID();
    }

    public long getPageId() {
        return this.getActiveObject().getCeoId();
    }

    public PageStatus getPageStatus() {
        if (this.pageStatus == null) {
            this.pageStatus = new PageStatus(this.getActiveObjects(), this.getActiveObject().getPageStatusAO());
        }
        return this.pageStatus;
    }

    public String getPageStatusLabel() {
        return this.getPageStatus() != null ? this.getPageStatus().getLabel() : null;
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(PageStatusContentEntityAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setPageStatus(PageStatus pageStatus) {
        this.pageStatus = pageStatus;
        this.getActiveObject().setPageStatusAO(pageStatus.getActiveObject());
        this.save();
    }
}

