/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.brikit.core.util.BrikitString;
import com.brikit.themepress.settings.BrikitConfigProperties;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemeCacheHelper;
import com.brikit.themepress.settings.ThemeProperties;
import com.brikit.themepress.util.ThemePress;
import java.io.File;

public class ThemeCssCacheHelper
extends ThemeCacheHelper {
    protected String mediaType;

    public ThemeCssCacheHelper(String key) {
        this(key, 0L);
    }

    public ThemeCssCacheHelper(String key, long compiledAt) {
        super(key, "css", compiledAt);
        this.setThemeName((String)this.getBits().first());
        this.setTweaker(this.getBits().size() > 1 ? (String)this.getBits().get(1) : "");
        this.setMediaType((String)this.getBits().last());
    }

    public String filesFromPlugins() {
        return BrikitThemeSettings.cssFilesForThemePressPlugins(this.getMediaType());
    }

    public String filesFromTheme() {
        ThemeProperties themeProperties = ThemeProperties.getThemeProperties(this.themeName);
        if (this.isPrint()) {
            return themeProperties.getCssFilesForPrintMedia();
        }
        if (!this.isEdit()) {
            return themeProperties.getCssFilesForAllMedia();
        }
        return "";
    }

    public String filesFromThemePress() {
        if (this.isPrint()) {
            return BrikitConfigProperties.getCssPrintFilesList();
        }
        if (this.isEdit()) {
            return BrikitConfigProperties.getCssEditFilesList();
        }
        return BrikitConfigProperties.getCssAllFilesList();
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public boolean isEdit() {
        return "edit".equalsIgnoreCase(this.mediaType);
    }

    public boolean isPrint() {
        return "print".equalsIgnoreCase(this.mediaType);
    }

    public boolean needsUpdate() {
        if (!this.isDeveloperMode()) {
            return false;
        }
        for (String filename : BrikitString.split((String)this.filesFromThemePress())) {
            File file = BrikitThemeSettings.getExternalDevelopmentFile(ThemePress.PLUGIN_KEY, filename, "css", "css");
            if (file.lastModified() <= this.compiledAt) continue;
            return true;
        }
        return false;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }
}

