/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.model.SpaceWrapper;
import com.brikit.themepress.model.StorableArchitecturePageReference;
import com.brikit.themepress.settings.BrikitThemeSettings;
import java.util.ArrayList;
import java.util.List;

public class ArchitectPageManager {
    public static boolean isDefaultBanner(Page aPage) {
        return aPage.equals((Object)BrikitThemeSettings.getDefaultBanner());
    }

    public static boolean isDefaultBlogLayout(Page aPage) {
        return aPage.equals((Object)BrikitThemeSettings.getDefaultBlogLayout());
    }

    public static boolean isDefaultFooter(Page aPage) {
        return aPage.equals((Object)BrikitThemeSettings.getDefaultFooter());
    }

    public static boolean isDefaultHeader(Page aPage) {
        return aPage.equals((Object)BrikitThemeSettings.getDefaultHeader());
    }

    public static boolean isDefaultLayout(Page aPage) {
        return aPage.equals((Object)BrikitThemeSettings.getDefaultLayout());
    }

    public static boolean isDefaultMenu(Page aPage) {
        return aPage.equals((Object)BrikitThemeSettings.getDefaultMenu());
    }

    public static List<AbstractPage> pagesUsingLayout(Page layoutPage) {
        ArrayList<AbstractPage> pages = new ArrayList<AbstractPage>();
        if (layoutPage == null) {
            return pages;
        }
        String layoutPageId = layoutPage.getIdAsString();
        for (Space space : Confluence.getAllSpaces()) {
            for (AbstractPage page : Confluence.getAllAbstractPages((Space)space)) {
                String data = Confluence.getMetaData((ContentEntityObject)page, (String)"com.brikit.themepress.layout.page.id");
                String pageLayoutId = BrikitString.isSet((String)data) ? StorableArchitecturePageReference.pageId(data) : null;
                if (!layoutPageId.equals(pageLayoutId)) continue;
                pages.add(page);
            }
        }
        return pages;
    }

    public static List<Space> spacesUsingArchitectPage(Page architectPage) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        if (architectPage == null) {
            return spaces;
        }
        for (Space space : Confluence.getAllSpaces()) {
            SpaceWrapper wrapper = SpaceWrapper.get(space);
            if (!architectPage.equals((Object)wrapper.getLayout()) && !architectPage.equals((Object)wrapper.getBlogLayout()) && !architectPage.equals((Object)wrapper.getBanner()) && !architectPage.equals((Object)wrapper.getFooter()) && !architectPage.equals((Object)wrapper.getHeader()) && !architectPage.equals((Object)wrapper.getMenu())) continue;
            spaces.add(space);
        }
        return spaces;
    }
}

