/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.core.actions.BrikitActionSupport;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.themepress.html.RichLinkContent;
import com.brikit.themepress.html.RichLinkContentCache;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class MultipleRichLinksAction
extends BrikitActionSupport {
    protected static final String ATTACHMENT_PREFIX = "att";
    protected List<String> contentIds;
    protected BrikitList<RichLinkContent> richLinks;
    protected boolean ignoreThumbnails;

    public List<String> getContentIds() {
        return this.contentIds;
    }

    public BrikitList<RichLinkContent> getRichLinks() {
        if (this.richLinks == null) {
            this.richLinks = new BrikitList();
            for (String id : this.getContentIds()) {
                ContentEntityObject ceo = null;
                try {
                    ConfluenceUser user;
                    Space space;
                    RichLinkContent richLink = null;
                    if (id.startsWith(ATTACHMENT_PREFIX)) {
                        id = id.substring(ATTACHMENT_PREFIX.length());
                    }
                    if ((ceo = Confluence.getContentEntity((String)id)) instanceof Attachment) {
                        richLink = RichLinkContent.get((Attachment)ceo);
                    } else if (ceo instanceof AbstractPage) {
                        richLink = RichLinkContentCache.getRichLinkContent((AbstractPage)ceo);
                    } else if (ceo instanceof Comment) {
                        richLink = RichLinkContent.get((Comment)ceo);
                    }
                    if (ceo == null && (space = Confluence.getSpace((String)id)) != null) {
                        richLink = RichLinkContent.get(space);
                    }
                    if (ceo == null && (user = Confluence.getConfluenceUserByUserKey((String)id)) != null) {
                        richLink = RichLinkContent.get(user);
                    }
                    if (richLink == null) continue;
                    this.richLinks.add((Object)richLink);
                }
                catch (Exception ex) {
                    if (ex instanceof MacroExecutionException) {
                        BrikitLog.logWarning((String)("Unable to create rich link for " + ceo + ", likely due to an improperly configured macro. Details:"), (Exception)ex);
                        continue;
                    }
                    BrikitLog.logWarning((String)("Unable to create rich link for " + ceo + " due to the following exception:"), (Exception)ex);
                }
            }
        }
        return this.richLinks;
    }

    public boolean isIgnoreThumbnails() {
        return this.ignoreThumbnails;
    }

    public boolean isRenderingRichLinksAction() {
        return true;
    }

    @StrutsParameter
    public void setContentIds(List<String> contentIds) {
        this.contentIds = contentIds;
    }

    @StrutsParameter
    public void setIgnoreThumbnails(boolean ignoreThumbnails) {
        this.ignoreThumbnails = ignoreThumbnails;
    }
}

