ThemePress.toInit(function ($) {

	// Move the "created by" text from the title to a more sensible place in the DOM
	$(".blog-post-list .blog-item .blog-title").each(function () {
		// Remove the title bits from the title (and save them)
		var $icon = $("span", this);
		var $title = $("a", this);
		$icon.remove();
		$title.remove();

		// Move the remaining text (created by) to the proper container
		$(this).next(".blog-item-creator").prepend($(this).text());

		// Reassemble the title
		$(this).html($icon).append(" ").append($title);
	});

	// On blogpost listings, dump the edit button in favor of a simple Read More link.
	$(".blog-post-listing .endsection").each(function () {
		var $link = $("a[href*='pages/editblogpost.action']", this).first();
		var $title = $(this).closest(".blog-post-listing").find("a.blogHeading").first();
		if ($link.length == 0) {
            $link = $title.clone();
            $link.removeClass("blogHeading");
        }
		var $newLink = $link.html("Read more...").attr("href", $title.attr("href")).addClass("aui-button-link read-more");
		var $labels = $(".label-list", this);
		$(this).html($newLink).append($labels);
	});

});
