/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitNumber;
import com.brikit.themepress.model.PageWrapper;
import java.util.List;
import java.util.Map;

public class RotateContentMacro
extends BrikitNoBodyMacro {
    public static final String SOURCE_PAGE = "source-page";
    public static final String SOURCE_PAGE_ID = "sourcePageId";
    public static final String DELAY = "delay";
    public static final String INITIAL_DELAY = "initial-delay";
    public static final String NON_RANDOM = "non-random";
    public static final String DISPLAY_THUMBNAILS = "display-thumbnails";
    public static final String THUMBNAIL_WIDTH = "thumbnail-width";
    public static final String THUMBNAIL_HEIGHT = "thumbnail-height";
    public static final String CURRENT_BLOCK = "currentBlockId";
    public static final String RENDER_WITHOUT_BLOCKS = "render-without-blocks";
    public static final String BODY = "body";
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/rotate-content.vm";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        List<MacroDefinition> blocks;
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        macroContext.velocityContextAdd((Object)"rotate-content-id", (Object)this.localSafeId("rotate-content-"));
        AbstractPage sourcePage = macroContext.pageFromValue(SOURCE_PAGE, null);
        if (sourcePage == null) {
            throw new MacroExecutionException(Confluence.getText((String)"com.brikit.macro.parameter.page.not.found", (Object[])new Object[]{Confluence.getText((String)"com.brikit.themepress.rotate-content.param.source-page.label")}));
        }
        if (sourcePage.equals((Object)macroContext.getPage())) {
            throw new MacroExecutionException(Confluence.getText((String)"com.brikit.macro.cannot.reference.its.own.page"));
        }
        if (!Confluence.canRead((AbstractPage)sourcePage)) {
            throw new MacroExecutionException(Confluence.getText((String)"brikit.config.insufficient.permissions"));
        }
        boolean renderWithoutBlocks = macroContext.booleanValue(RENDER_WITHOUT_BLOCKS);
        PageWrapper sourceWrapper = PageWrapper.get(sourcePage);
        try {
            sourceWrapper.ensureLayer();
            blocks = sourceWrapper.blocks();
            macroContext.velocityContextAdd((Object)"blockIds", sourceWrapper.blockIds());
            macroContext.velocityContextAdd((Object)"renderedBlocksHTML", (Object)Confluence.render((String)this.macrosAsStorageFormat(sourcePage, blocks, renderWithoutBlocks), (AbstractPage)sourcePage));
        }
        catch (Exception ex) {
            throw new MacroExecutionException("Unable to read blocks on the source page.", (Throwable)ex);
        }
        MacroDefinition selectedBlock = blocks.get(macroContext.booleanValue(NON_RANDOM) ? 0 : BrikitNumber.randomIndex(blocks));
        macroContext.velocityContextAdd((Object)THUMBNAIL_HEIGHT, (Object)macroContext.stringValue(THUMBNAIL_HEIGHT, "36"));
        macroContext.velocityContextAdd((Object)THUMBNAIL_WIDTH, (Object)macroContext.stringValue(THUMBNAIL_WIDTH, "36"));
        if (macroContext.booleanValue(NON_RANDOM)) {
            macroContext.velocityContextAdd((Object)"nonRandom", (Object)"true");
        }
        if (renderWithoutBlocks) {
            macroContext.velocityContextAdd((Object)"renderWithoutBlocks", (Object)"true");
        } else {
            macroContext.velocityContextAdd((Object)"renderWithoutBlocks", (Object)"false");
        }
        if (!macroContext.hasStringValue(INITIAL_DELAY)) {
            macroContext.velocityContextAdd((Object)INITIAL_DELAY, (Object)macroContext.stringValue(DELAY));
        }
        macroContext.velocityContextAdd((Object)SOURCE_PAGE_ID, (Object)sourcePage.getId());
        macroContext.velocityContextAdd((Object)CURRENT_BLOCK, (Object)sourceWrapper.getId(selectedBlock));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    protected String macrosAsStorageFormat(AbstractPage abstractPage, List<MacroDefinition> macros, boolean renderWithoutBlocks) throws Exception {
        StringBuilder builder = new StringBuilder();
        for (MacroDefinition macro : macros) {
            MacroParser.setName((MacroDefinition)macro, (String)"rendered-content-block");
            if (renderWithoutBlocks) {
                MacroParser.setBooleanParameter((MacroDefinition)macro, (String)RENDER_WITHOUT_BLOCKS, (boolean)true, (AbstractPage)abstractPage);
            }
            builder.append(MacroParser.macroAsStorageFormat((AbstractPage)abstractPage, (MacroDefinition)macro));
        }
        return builder.toString();
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

