/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.settings.BrikitThemeSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ClearSpaceArchitectSettingsAction
extends ThemePressActionSupport {
    protected String categoryName;

    public String clearAllSpaces() throws Exception {
        return this.clearSpaces(Confluence.getAllSpaces());
    }

    protected String clearSpaces(List<Space> spaces) throws Exception {
        try {
            for (Space space : spaces) {
                BrikitThemeSettings.clearSpaceArchitectSettings(space);
            }
        }
        catch (Exception ex) {
            this.addActionError(ex.getMessage());
            BrikitLog.logError((String)"Failed to clear architect settings for spaces.", (Exception)ex);
            return "error";
        }
        this.setResult(Integer.toString(spaces.size()));
        return "success";
    }

    public String clearCategorySpaces() throws Exception {
        return this.clearSpaces(Confluence.spacesWithCategories(Arrays.asList(this.getCategoryName()), new ArrayList()));
    }

    public String execute() throws Exception {
        return this.clearSpaces(Arrays.asList(this.getSpace()));
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    @StrutsParameter
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
}

