(function ($) {
	ThemePress.TopicTree = {

		convertPageLabels: function () {
			$("#labels-section .label-list .aui-label-split-main").each(function () {
				var label = $(this).text();
				$(this).closest("li")
					.attr("title", label)
					.tooltip({aria: true});
				$(this).css({cursor: "default"});
				var title = ThemePress.TopicTree.labelMapping[label];
				if (!title) title = ThemePress.String.titleize(label);
				if (title) $(this).text(title);
			});
		},
		
		drawTopicTree: function ($parent, levelName, data) {
			$(".topic-tree-loading, .topic-subtree-loading", $parent).remove();
			
			var $treeTop = $parent.hasClass("topic-tree") ? $parent : $parent.closest(".topic-tree");
			// If we can't find the topic tree, it's because we're expanding children on initial page load
			// and $parent isn't in the DOM yet, so just grab the first topic tree on the page to use for settings
			if (!$treeTop.length) $treeTop = ThemePress.TopicTree.topicTree();
			
			// If we're on the show-more item, remove it and act as if the parent node triggered the load
			var $ul;
			var showMore = $parent.hasClass("show-more");
			if (showMore) {
				var $loader = $parent;
				$ul = $parent.closest("ul");
				$parent = $ul.closest("li");
				$loader.remove();
			}
			else {
				$ul = $("<ul>").addClass("topic-" + levelName + "list");
			}

			if (!$(data).length) {
				var $li = $("<li>")
					.addClass("acs-tree-item leaf no-results")
					.append($("<span>").addClass("icon icon-section"))
					.append($("<span>").addClass("message").text("No results"));
				$ul.append($li);
			}

			var showSpaceNames = $treeTop.data("show-space-names");
			var showCreateDate = $treeTop.data("show-create-date");
			var showCreator    = $treeTop.data("show-creator");
			$(data).each(function () {

				var showChildren = typeof(this.children) == "object";
				var loadChildren = typeof(this.childrenURL) == "string";

				var $icon = $("<span>")
					.addClass("icon icon-section")
					.addClass(showChildren ? "icon-section-opened" : "icon-section-closed");

				var $a = $("<a>").text(this.title).addClass("title-link");
				var paramGlue = this.url.indexOf("?") == -1 ? "?" : "&";
				if (loadChildren) $a.attr("href", this.childrenURL);
				else if (showChildren) $a.attr("href", "#");
				else if (this.url) $a.attr("href", this.url + paramGlue + "topic=" + this.label);

				var $li = $("<li>")
					.addClass("acs-tree-item topic-" + levelName)
					.append($icon)
					.append($a);
				if ((ThemePress.contextPath + ThemePress.pageUrl) == this.url) $li.addClass("current");
				if (this.label) $li.attr("data-label", this.label);
				if (this.spaceName && showSpaceNames || this.createDate && showCreateDate || this.creator && showCreator) {
					var $extras = $("<span>").addClass("extras");
					if (this.spaceName && showSpaceNames) {
						$extras
							.append(" ")
							.append($("<span>")
							.addClass("space-name")
							.text(this.spaceName));
					}
					if (this.createDate && showCreateDate) {
						$extras
							.append(" ")
							.append($("<span>")
							.addClass("create-date")
							.text(this.createDate));
					}
					if (this.creatorUsername && showCreator) {
						var user = {name: this.creatorUsername, fullName: this.creatorFullName, url: ThemePress.contextPath + "/display/~" + encodeURIComponent(this.creatorUsername) };
						$extras
							.append(" ")
							.append($("<span>")
							.addClass("creator")
							.html(AJS.Confluence.Templates.Likes.userLink({user: user})));
					}
					$li.append($extras);
				}
				if (!showChildren && !loadChildren) $li.addClass("leaf");
				else $li.addClass("grouping");
				if (this.skipResults) $li.attr("data-skip-results", this.skipResults).addClass("show-more");

				if (showChildren) ThemePress.TopicTree.drawTopicTree($li, "next", this.children);

				$ul.append($li);
			});

			if (!showMore) {
				$parent
					.append($ul)
					.children("a").attr("href", "#");
			}
				
			if (showCreator) Confluence.Binder.userHover();
		},
		
		initialize: function () {

			var $tree = $(this);

			// Only set up the click listener on the outer tree
			// The unbind addresses PRESS-1230: Topic Tree macro: node collapse issue on tabs
			$tree.unbind().on("click", "a, span.icon", ThemePress.TopicTree.toggleNode);

			// Convert the page labels if requested
			if ($tree.data("convert-page-labels")) {
				$("#labels-section").on("click", ".label-list .aui-label-split-main", function () { return false;});
				// Labels editing resets the label list, so need to re-convert after every ajax send
				$(document).ajaxComplete(ThemePress.TopicTree.convertPageLabels);
				ThemePress.TopicTree.convertPageLabels();
			}
			
			// Click the current topic (if any) to asynchronously load its children
			$tree.find(".topic-label.current a").click();
		},
		
		load: function () {
			
			var $tree = $(this);
			var expandTopic = false;
			
			// // If we're drawing the top-level tree (topics)
			// if ($tree.hasClass("topic-tree")) {
			// 	// Only set up the click listener on the outer tree
			// 	$tree.on("click", "a, span.icon", ThemePress.TopicTree.toggleNode);
			//
			// 	// Expand the current topic if we have one
			// 	expandTopic = ThemePress.urlParams["topic"];
			//
			// 	if ($tree.data("convert-page-labels")) {
			// 		$("#labels-section").on("click", ".label-list .aui-label-split-main", function () { return false;});
			// 		// Labels editing resets the label list, so need to re-convert after every ajax send
			// 		$(document).ajaxComplete(ThemePress.TopicTree.convertPageLabels);
			// 		ThemePress.TopicTree.convertPageLabels();
			// 	}
			// }
			
			var $treeTop = $tree.hasClass("topic-tree") ? $tree : $tree.closest(".topic-tree");
			var href = $tree.data("href") || $tree.children("a").attr("href");
			$.get(href, 
				{
					pageId: ThemePress.pageId,
					skipResults: $tree.data("skip-results"),
					maxResultsPerLabel: $treeTop.data("max-results-per-label"),
					label: $tree.data("label"),
					expandTopic: (expandTopic ? expandTopic : ""),
					labels: $treeTop.data("labels"),
					labelNames: $treeTop.data("label-names"),
					order: $treeTop.data("order"),
					includePages: $treeTop.data("include-pages"),
					includeBlogposts: $treeTop.data("include-blogposts"),
					includeFiles: $treeTop.data("include-files"),
					spaceFilter: $treeTop.data("space-filter"),
					spaceKeysOrCategories: $treeTop.data("space-keys-or-categories")
				}, 
				function (data, textStatus, jqXHR) {
					if (data.success) {
						ThemePress.TopicTree.drawTopicTree($tree, "label", data.result);
					}
					else {
						ThemePress.Dialog2.alert("<p>" + data.message + "</p>", {title: "Error Loading Tree"});
						$tree.children(".topic-subtree-loading").remove();
					}
				},
				"json"
			);

		},
		
		showWaiting: function (element) {
			var $spinner = $("<img>")
				.addClass("wait")
				.attr("src", ThemePress.contextPath + "/images/icons/wait.gif");
			var $loading = $("<div>")
				.addClass("topic-subtree-loading")
				.append($spinner);
			element.append($loading);
		},
		
		toggleNode: function (event) {
			var $node = $(this).closest("li");
			
			// Just fire the regular response if we're on a tree leaf
			if ($node.hasClass("leaf") && !$node.hasClass("show-more")) return;

			// Block normal response from happening
			event.stopPropagation();
			event.preventDefault();
			
			// Stop if we're already waiting for something to load
			if ($node.children(".topic-subtree-loading").length) return;
			
			// If the href is a simple hash, then it's a loaded subtree and wants to toggle open/closed
			var href = $node.children("a").attr("href");
			if (href == "#") {
				$node.children("ul").slideToggle("fast");
				$node.children(".icon").toggleClass("icon-section-opened").toggleClass("icon-section-closed");
			}
			// Otherwise, load the subtree from the server
			else {
				ThemePress.TopicTree.showWaiting($node);
				ThemePress.TopicTree.load.call($node);
				if (!$node.hasClass("show-more")) {
					$node.children(".icon")
						.toggleClass("icon-section-opened")
						.toggleClass("icon-section-closed");
				}
			}
		},

		topicTree: function () {
			return $(".topic-tree");
		}
		
	};

})(jQuery);

ThemePress.toInit(function ($) {
	// ThemePress.TopicTree.topicTree().each(ThemePress.TopicTree.load);
});
