/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitString;
import java.lang.reflect.Method;
import java.util.Map;

public class UserInfoMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/user-info.vm";
    public static final String USER = "user";
    public static final String PROFILE_LINK_TEXT = "profile-link-text";
    public static final String PROFILE_LINK_TEXT_HTML = "profileLinkTextHTML";
    public static final String CUSTOM_PROFILE_LINK = "custom-profile-link";
    public static final String AVATAR_HEIGHT = "avatar-height";
    public static final String AVATAR_WIDTH = "avatar-width";
    public static final String AVATAR_MARGIN = "avatar-margin";
    public static final String USER_PROFILE = "user-profile";
    public static final String CONTEXT_PATH_FIELD = "@contextPath";
    public static final String NAME_FIELD = "@name";
    public static final String USERNAME_FIELD = "@username";
    public static final String EMAIL_FIELD = "@email";
    public static final String USERNAME_PARAM = "username";
    public static final String CREATOR = "@creator";
    public static final String MODIFIER = "@modifier";
    public static final String PAGE_OWNER = "@owner";
    public static final String SPACE_OWNER = "@space-owner";
    public static final String OTHER_PROFILE_FIELDS_PARAM = "other-profile-fields";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        ConfluenceUser user = null;
        String username = macroContext.stringValue(USERNAME_PARAM);
        if (CREATOR.equals(username)) {
            user = macroContext.getPage().getCreator();
        } else if (MODIFIER.equals(username)) {
            user = macroContext.getPage().getLastModifier();
        } else if (PAGE_OWNER.equals(username) || SPACE_OWNER.equals(username)) {
            Object contentFlow = macroContext.getVelocityContext().get("contentFlow");
            if (contentFlow != null) {
                String methodName = PAGE_OWNER.equals(username) ? "pageContentOwner" : "spaceContentOwner";
                try {
                    Method method = contentFlow.getClass().getMethod(methodName, AbstractPage.class);
                    user = (User)method.invoke(contentFlow, macroContext.getPage());
                }
                catch (Exception ex) {
                    BrikitLog.logDebug("Content Flow object does not have " + methodName + "(abstractPage) method.");
                }
            }
        } else {
            user = BrikitString.isSet(username) ? Confluence.getConfluenceUser(username) : Confluence.getConfluenceUser();
        }
        if (user != null) {
            macroContext.velocityContextAdd(USER, user);
        } else {
            macroContext.velocityContextAdd(USERNAME_PARAM, Confluence.getText("com.brikit.themepress.user-info.anonymous"));
        }
        String linkText = macroContext.stringValue(PROFILE_LINK_TEXT, "com.brikit.themepress.user-info.profile.default.text");
        if (user != null) {
            linkText = linkText.replaceAll(NAME_FIELD, user.getFullName());
            linkText = linkText.replaceAll(USERNAME_FIELD, user.getName());
        }
        macroContext.velocityContextAdd(PROFILE_LINK_TEXT_HTML, linkText);
        String url = macroContext.stringValue(CUSTOM_PROFILE_LINK, "com.brikit.themepress.user-info.profile.default.url");
        url = url.replaceAll(CONTEXT_PATH_FIELD, Confluence.getContextPath());
        if (user != null) {
            url = url.replaceAll(USERNAME_FIELD, user.getName());
            url = url.replaceAll(EMAIL_FIELD, user.getEmail());
        }
        macroContext.velocityContextAdd(CUSTOM_PROFILE_LINK, url);
        if (macroContext.hasStringValue(OTHER_PROFILE_FIELDS_PARAM)) {
            macroContext.velocityContextAdd(OTHER_PROFILE_FIELDS_PARAM, macroContext.commaSeparatedListValue(OTHER_PROFILE_FIELDS_PARAM));
            if (user != null) {
                macroContext.velocityContextAdd(USER_PROFILE, Confluence.getUserProfileDetails((User)user));
            }
        }
        macroContext.velocityContextAdd(AVATAR_HEIGHT, macroContext.pixelSize(AVATAR_HEIGHT, 80L));
        macroContext.velocityContextAdd(AVATAR_WIDTH, macroContext.pixelSize(AVATAR_WIDTH, 80L));
        macroContext.velocityContextAdd(AVATAR_MARGIN, macroContext.stringValue(AVATAR_MARGIN, "0px"));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }
}

