/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.model.SpaceWrapper;
import com.brikit.themepress.util.ArchitectDesignerResponse;

public class AddMenuAction
extends ThemePressActionSupport {
    protected String name;
    protected boolean oneLevelMenu;
    protected boolean twoLevelMenu;
    protected boolean panelsMenu;

    @Override
    public String execute() throws Exception {
        if (!BrikitString.isSet(this.getName())) {
            return this.setJSONError(Confluence.getText("com.brikit.menu.title.cannot.be.blank"));
        }
        Page newMenu = null;
        SpaceWrapper defaultsSpaceWrapper = SpaceWrapper.getThemePressDefaultSpaceWrapper();
        if (this.isOneLevelMenu()) {
            newMenu = defaultsSpaceWrapper.getOrCreateOneLevelMenu(this.getName());
        } else if (this.isTwoLevelMenu()) {
            newMenu = defaultsSpaceWrapper.getOrCreateTwoLevelMenu(this.getName());
        } else if (this.isPanelsMenu()) {
            newMenu = defaultsSpaceWrapper.getOrCreatePanelsMenu(this.getName());
        }
        JSONObject json = ArchitectDesignerResponse.jsonResponse((AbstractPage)newMenu, true);
        this.setJSONResult(json);
        return "success";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean isOneLevelMenu() {
        return this.oneLevelMenu;
    }

    public void setOneLevelMenu(boolean oneLevelMenu) {
        this.oneLevelMenu = oneLevelMenu;
    }

    public boolean isTwoLevelMenu() {
        return this.twoLevelMenu;
    }

    public void setTwoLevelMenu(boolean twoLevelMenu) {
        this.twoLevelMenu = twoLevelMenu;
    }

    public boolean isPanelsMenu() {
        return this.panelsMenu;
    }

    public void setPanelsMenu(boolean panelsMenu) {
        this.panelsMenu = panelsMenu;
    }
}

