/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.macros;

import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.targetedsearch.macros.ContentQueryMacro;
import com.brikit.targetedsearch.model.AttachmentToResultConverter;
import jakarta.inject.Inject;
import java.util.Map;

public class AttachmentsTableMacro
extends ContentQueryMacro {
    public static final String TEMPLATE_NAME = "targeted-search/templates/attachments-table.vm";
    protected static final String CONTAINER_PAGE_PARAM = "containerPage";
    protected static final String CONTAINER_PAGE_ID = "containerPageId";
    protected static final String ATTACHMENT_RESULTS = "attachmentResults";
    protected static final int MAX_RESULTS = 50;

    @Inject
    public AttachmentsTableMacro(@ComponentImport CQLSearchService searchService) {
        super(searchService);
    }

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = this.initializeMacroContext(parameters, body, conversionContext);
        this.finishInitializing(macroContext, null);
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    protected void finishInitializing(BrikitMacroContext macroContext, String query) throws MacroExecutionException {
        macroContext.velocityContextAdd((Object)"displayTable", (Object)true);
        macroContext.velocityContextAdd((Object)"max", (Object)50);
        macroContext.velocityContextAdd((Object)"queryAfterPageLoad", (Object)true);
        AbstractPage containerPage = macroContext.pageFromValue(CONTAINER_PAGE_PARAM);
        if (macroContext.hasStringValue(CONTAINER_PAGE_PARAM) && containerPage == null) {
            throw new MacroExecutionException("No page or blogpost found for " + macroContext.stringValue(CONTAINER_PAGE_PARAM));
        }
        if (containerPage == null) {
            containerPage = macroContext.getPage();
        }
        macroContext.velocityContextAdd((Object)CONTAINER_PAGE_ID, (Object)containerPage.getId());
        macroContext.velocityContextAdd((Object)ATTACHMENT_RESULTS, (Object)AttachmentToResultConverter.toJSONObject(Confluence.getAttachments((AbstractPage)containerPage)));
        if (macroContext.isPreviewContext()) {
            this.fireSearch(macroContext, query, 50);
        }
    }

    @Override
    protected void validateQuery(String cql, String explicitCql) throws MacroExecutionException {
    }
}

