(function ($) { 

	// To simplify brikit-core, reference core javascript using BrikitCore
	var BrikitCore = this[brikitProduct];

	
	BrikitCore.MultiPanelDialog = function (dialogSelector, dialogContent, options) {
		var self = this;

		self.dialogSelector = dialogSelector;
		self.auiDialogObject = AJS.dialog2($(dialogContent)).show();
		self.okButtonText = options.okButton || "OK";
		self.submitCallback = options.submit || function () { self.hide.call(self); };
		self.panelChangeCallback = options.panelChange || function () { return false; };
		self.panelLoadedForContextCallback = options.panelLoadedForContext || function () { return false; };
		self.initializeCallback = options.initialize;
		self.loadedContextPanels = {};
		self.initialize();
	};
	
	BrikitCore.MultiPanelDialog.prototype.addPanelForContext = function (loadContext, url, responseText, textStatus, XMLHttpRequest) {
		// Build a panel to contain the response, the class and data-context aren't necessary but handy for debugging the DOM
		var $panel = $("<div>").addClass("context-panel").attr("data-context", loadContext).html(responseText);
		
		// Save this panel under the context and url for future re-use
		this.loadedPanelForContext(loadContext, url, $panel);
		
		// Put the panel into the wizard and adjust
		this.setCurrentPanelContent($panel);

		// Let the call know a context panel was loaded
		this.panelChangeCallback.call(this, this.currentPanel);
		
		this.setEnablement();
	};
	
	BrikitCore.MultiPanelDialog.prototype.setCurrentPanelContent = function (content) {
		this.currentPanel.html(content);
		this.updateDialogTitle();
	};
	
	BrikitCore.MultiPanelDialog.prototype.closeButton = function () {
		return $("#dialog-close-button", this.dialog());
	};

	BrikitCore.MultiPanelDialog.prototype.closeButtonPressed = function (event) {
		event.preventDefault();
		this.auiDialogObject.hide();
	};
	
	BrikitCore.MultiPanelDialog.prototype.dialog = function () {
		return $(this.dialogSelector);
	};
	
	BrikitCore.MultiPanelDialog.prototype.dialogContent = function () {
		return this.find(".aui-dialog2-content");
	};
	
	BrikitCore.MultiPanelDialog.prototype.dialogTitle = function () {
		return this.find(".aui-dialog2-header-main");
	};
	
	BrikitCore.MultiPanelDialog.prototype.find = function (selector) {
		return this.dialog().find(selector);
	};
	
	BrikitCore.MultiPanelDialog.prototype.hasNextPanel = function () {
		return this.nextPanel().length;
	};
	
	BrikitCore.MultiPanelDialog.prototype.hasPreviousPanel = function () {
		return this.previousPanel().length;
	};
	
	BrikitCore.MultiPanelDialog.prototype.hide = function () {
		this.auiDialogObject.hide();
	};

	BrikitCore.MultiPanelDialog.prototype.initialize = function() {
		var self = this;
		self.closeButton()   .click(function(e) { self.closeButtonPressed.call(self, e); });
		self.previousButton().click(function(e) { self.previousButtonPressed.call(self, e); });
		self.nextButton()    .click(function(e) { self.nextButtonPressed.call(self, e); });
		self.submitButton()  .click(function(e) { self.submitButtonPressed.call(self, e); })
							 .text(self.okButtonText);
		
		
		self.moveToPanel(self.dialog().find(".brikit-dialog-panel").first());
		
		self.initializeCallback.call(self);
	};
	
	BrikitCore.MultiPanelDialog.prototype.loadContext = function (newContext) {
		if (newContext) this.dialogContent().data("context", newContext);
		return this.dialogContent().data("context");
	};
	
	BrikitCore.MultiPanelDialog.prototype.loadedPanelForContext = function (loadContext, url, $panel) {
		this.loadedContextPanels[url] = this.loadedContextPanels[url] || {};
		if ($panel) this.loadedContextPanels[url][loadContext] = $panel;
		return this.loadedContextPanels[url][loadContext];
	};
	
	BrikitCore.MultiPanelDialog.prototype.loadPanelForContext = function () {
		var self = this;
		
		var url = self.currentPanel.data("context-loader");
		if (!url) return true;

		// Hide previous showing panel
		self.currentPanel.find(".context-panel").remove();

		// Check for already loaded panels
		var loadContext = self.loadContext();
		var $loadedPanel = self.loadedPanelForContext(loadContext, url);
		// var $loadedPanel = self.currentPanel.find(".context-panel[data-context='" + loadContext + "']");
		if ($loadedPanel) {
			self.setCurrentPanelContent($loadedPanel);
			return true;
		}

		self.setCurrentPanelContent("");
		self.currentPanel.spin();
		$.get(url, { loadContext: loadContext, pageId: BrikitCore.pageId, spaceKey: BrikitCore.spaceKey }, function (r,t,x) { 
			self.addPanelForContext.call(self, loadContext, url, r, t, x);
		});
		return false;
	};
	
	BrikitCore.MultiPanelDialog.prototype.moveToPanel = function ($panel) {
		var $old = this.currentPanel;
		this.dialog().find(".brikit-dialog-panel").hide();
		$panel.show();
		this.currentPanel = $panel;
		
		this.updateDialogTitle();
		
		// If loaded is false, we're waiting for the server to load the panel, so deferr callback and enablement until 
		// the load completes (see addPanelForContext() above)
		var loaded = this.loadPanelForContext();
		if (!loaded) return;
		
		this.panelChangeCallback.call(this, $panel);
		this.setEnablement();
	};

	BrikitCore.MultiPanelDialog.prototype.nextButton = function () {
		return $("#dialog-next-button", this.dialog());
	};

	BrikitCore.MultiPanelDialog.prototype.nextButtonPressed = function (event) {
		event.preventDefault();
		if (this.hasNextPanel()) this.moveToPanel(this.nextPanel());
	};
	
	BrikitCore.MultiPanelDialog.prototype.nextPanel = function () {
		return this.currentPanel.next(".brikit-dialog-panel");
	};
	
	BrikitCore.MultiPanelDialog.prototype.previousButton = function () {
		return $("#dialog-previous-button", this.dialog());
	};

	BrikitCore.MultiPanelDialog.prototype.previousButtonPressed = function (event) {
		event.preventDefault();
		if (this.hasPreviousPanel()) this.moveToPanel(this.previousPanel());
	};
	
	BrikitCore.MultiPanelDialog.prototype.previousPanel = function () {
		return this.currentPanel.prev(".brikit-dialog-panel");
	};
	
	BrikitCore.MultiPanelDialog.prototype.setEnablement = function () {
		// if (this.hasNextPanel()) this.nextButton().show();
		// else this.nextButton().hide();
		this.nextButton().adjustAttr("aria-disabled", "true", !this.hasNextPanel());

		// if (this.hasPreviousPanel()) this.previousButton().show();
		// else this.previousButton().hide();
		this.previousButton().adjustAttr("aria-disabled", "true", !this.hasPreviousPanel());

		// if (!this.hasNextPanel()) this.submitButton().show();
		// else this.submitButton().hide();
		this.submitButton().adjustAttr("aria-disabled", "true", this.hasNextPanel())
	};
	
	BrikitCore.MultiPanelDialog.prototype.showBusy = function (busy) {
		if (typeof(busy) == "undefined") return this.submitButton().find(".spinner").length;
		else if (busy) this.submitButton().spin();
		else this.submitButton().spinStop();
	};

	BrikitCore.MultiPanelDialog.prototype.submitButton = function () {
		return $("#dialog-submit-button", this.dialog());
	};

	BrikitCore.MultiPanelDialog.prototype.submitButtonPressed = function (event) {
		event.preventDefault();
		if (this.showBusy()) return;
		this.showBusy(true);
		this.submitCallback.call(this, event);
	};
	
	BrikitCore.MultiPanelDialog.prototype.updateDialogTitle = function () {
		var title = this.currentPanel.find(".override-dialog-title").val() || this.currentPanel.data("title");
		if (title) this.dialogTitle().html(title);
	};

})(jQuery);
