TargetedSearch.toInit(function ($) {

    if (!$(".app-configuration-options").length) return;
    
	var closeFilterCategoryOrder = function (event) {
	    event.preventDefault();
	    AJS.dialog2("#filter-category-order-dialog").hide();
	}
	
	var closeCascadePermissions = function (event) {
	    event.preventDefault();
	    AJS.dialog2("#cascade-permissions-dialog").hide();
	}
	
	var closeTaxonomyPermissions = function (event) {
	    event.preventDefault();
	    AJS.dialog2("#taxonomy-permissions-dialog").hide();
	}
	
	var closeMoreHelpLink = function (event) {
	    event.preventDefault();
	    AJS.dialog2("#more-help-link-dialog").hide();
	}
	
	var closeDefaultTooltip = function (event) {
	    event.preventDefault();
	    AJS.dialog2("#default-tooltip-dialog").hide();
	}
	
	var closeAllTooltip = function (event) {
	    event.preventDefault();
	    AJS.dialog2("#all-tooltip-dialog").hide();
	}
	
	var closeAnyTooltip = function (event) {
	    event.preventDefault();
	    AJS.dialog2("#any-tooltip-dialog").hide();
	}
	
	var closeSearchMacroParameters = function (event) {
	    event.preventDefault();
	    AJS.dialog2("#search-macro-parameters-dialog").hide();
	}
	
	var editFilterCategoryOrder = function (event) {
		event.preventDefault();
		AJS.dialog2("#filter-category-order-dialog").show();
	}
	
	var editCascadePermissions = function (event) {
		event.preventDefault();
		AJS.dialog2("#cascade-permissions-dialog").show();
	}
	
	var editTaxonomyPermissions = function (event) {
		event.preventDefault();
		AJS.dialog2("#taxonomy-permissions-dialog").show();
	}
	
	var editMoreHelpLink = function (event) {
		event.preventDefault();
		AJS.dialog2("#more-help-link-dialog").show();
	}
	
	var editDefaultTooltip = function (event) {
		event.preventDefault();
		AJS.dialog2("#default-tooltip-dialog").show();
	}
	
	var editAllTooltip = function (event) {
		event.preventDefault();
		AJS.dialog2("#all-tooltip-dialog").show();
	}
	
	var editSearchMacroParameters = function (event) {
		event.preventDefault();
		AJS.dialog2("#search-macro-parameters-dialog").show();
	}
	
	var editAnyTooltip = function (event) {
		event.preventDefault();
		AJS.dialog2("#any-tooltip-dialog").show();
	}
	
	var saveFilterCategoryOrder = function (event) {
	    event.preventDefault();
        const data = { categories: $("#filter-category-order-field").val() };
        TargetedSearch.addToken(data);
		jQuery.ajax({
			url: TargetedSearch.contextPath + "/plugins/targetedsearch/settings/savefiltercategoryorder.action", 
			data: data,
			method: "POST",
			success: TargetedSearch.reloadBrowser,
			error: function (xhRequest, textStatus, errorThrown) {
				AJS.messages.error({
				   title: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error.title"),
				   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
				});
			}
		});
	}

	var saveCascadePermissions = function (event) {
	    event.preventDefault();
        const data = { groups: $("#cascade-permissions-field").val() };
        TargetedSearch.addToken(data);
		jQuery.ajax({
			url: TargetedSearch.contextPath + "/plugins/targetedsearch/settings/savecascadepermissions.action", 
			data: data,
			method: "POST",
			success: TargetedSearch.reloadBrowser,
			error: function (xhRequest, textStatus, errorThrown) {
				AJS.messages.error({
				   title: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error.title"),
				   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
				});
			}
		});
	}

	var saveMoreHelpLink = function (event) {
	    event.preventDefault();
        const data = { moreHelpLink: $("#more-help-link-field").val() };
        TargetedSearch.addToken(data);
		jQuery.ajax({
			url: TargetedSearch.contextPath + "/plugins/targetedsearch/settings/savemorehelplink.action", 
			data: data,
			method: "POST",
			success: TargetedSearch.reloadBrowser,
			error: function (xhRequest, textStatus, errorThrown) {
				AJS.messages.error({
				   title: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error.title"),
				   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
				});
			}
		});
	}

	var saveDefaultTooltip = function (event) {
	    event.preventDefault();
        const data = { defaultTooltip: $("#default-tooltip-field").val() };
        TargetedSearch.addToken(data);
		jQuery.ajax({
			url: TargetedSearch.contextPath + "/plugins/targetedsearch/settings/savedefaulttooltip.action", 
			data: data,
			method: "POST",
			success: TargetedSearch.reloadBrowser,
			error: function (xhRequest, textStatus, errorThrown) {
				AJS.messages.error({
				   title: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error.title"),
				   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
				});
			}
		});
	}

	var saveAllTooltip = function (event) {
	    event.preventDefault();
        const data = { allTooltip: $("#all-tooltip-field").val() };
        TargetedSearch.addToken(data);
		jQuery.ajax({
			url: TargetedSearch.contextPath + "/plugins/targetedsearch/settings/savealltooltip.action", 
			data: data,
			method: "POST",
			success: TargetedSearch.reloadBrowser,
			error: function (xhRequest, textStatus, errorThrown) {
				AJS.messages.error({
				   title: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error.title"),
				   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
				});
			}
		});
	}

	var saveAnyTooltip = function (event) {
	    event.preventDefault();
        const data = { anyTooltip: $("#any-tooltip-field").val() };
        TargetedSearch.addToken(data);
		jQuery.ajax({
			url: TargetedSearch.contextPath + "/plugins/targetedsearch/settings/saveanytooltip.action", 
			data: data,
			method: "POST",
			success: TargetedSearch.reloadBrowser,
			error: function (xhRequest, textStatus, errorThrown) {
				AJS.messages.error({
				   title: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error.title"),
				   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
				});
			}
		});
	}

	var saveSearchMacroParameters = function (event) {
	    event.preventDefault();
        const data = { searchMacroParameters: $("#search-macro-parameters-field").val() };
        TargetedSearch.addToken(data);
		jQuery.ajax({
			url: TargetedSearch.contextPath + "/plugins/targetedsearch/settings/savesearchmacroparameters.action", 
			data: data,
			method: "POST",
			success: TargetedSearch.reloadBrowser,
			error: function (xhRequest, textStatus, errorThrown) {
				AJS.messages.error({
				   title: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error.title"),
				   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
				});
			}
		});
	}

	var saveRichLinksDisabled = function (richLinksDisabledState) {
        const data = { disableRichLinks: richLinksDisabledState ? "on" : "off" };
        TargetedSearch.addToken(data);
		jQuery.ajax({
			url: TargetedSearch.contextPath + "/plugins/targetedsearch/settings/editrichlinkssetting.action", 
			data: data,
			method: "POST",
			success: TargetedSearch.reloadBrowser,
			error: function (xhRequest, textStatus, errorThrown) {
				AJS.messages.error({
				   title: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error.title"),
				   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
				});
			}
		});
	}
	
	var saveTaxonomyPermissions = function (event) {
	    event.preventDefault();
        const data = { groups: $("#taxonomy-permissions-field").val() };
        TargetedSearch.addToken(data);
		jQuery.ajax({
			url: TargetedSearch.contextPath + "/plugins/targetedsearch/settings/savetaxonomypermissions.action", 
			data: data,
			method: "POST",
			success: TargetedSearch.reloadBrowser,
			error: function (xhRequest, textStatus, errorThrown) {
				AJS.messages.error({
				   title: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error.title"),
				   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
				});
			}
		});
	}

 	var toggleRichLinksDisabled = function (event) {
		event.preventDefault();
		
		var disabled = $(this).data("rich-links-disabled");
		var requestedState = disabled ? 
			 TargetedSearch.getText("com.brikit.targetedsearch.settings.confirm.rich.links.disabled.enable") : 
			 TargetedSearch.getText("com.brikit.targetedsearch.settings.confirm.rich.links.disabled.disable");
		var message = TargetedSearch.getText("com.brikit.targetedsearch.settings.confirm.rich.links.disabled", [requestedState]);
		return TargetedSearch.Dialog2.confirm(message, {title: TargetedSearch.getText("com.brikit.targetedsearch.settings.confirm.rich.links.disabled.title")}, function () {
			saveRichLinksDisabled(!disabled);
		});
 	}
	
	$("#edit-filter-category-order").click(editFilterCategoryOrder);
	$("#edit-taxonomy-permissions").click(editTaxonomyPermissions);
	$("#edit-more-help-link").click(editMoreHelpLink);
	$("#edit-default-tooltip").click(editDefaultTooltip);
	$("#edit-all-tooltip").click(editAllTooltip);
	$("#edit-any-tooltip").click(editAnyTooltip);
	$("#edit-search-macro-parameters").click(editSearchMacroParameters);
	$("#edit-cascade-permissions").click(editCascadePermissions);
	$("#toggle-rich-links").click(toggleRichLinksDisabled);
	
	$("#filter-category-order-dialog").on("click", "button.save", saveFilterCategoryOrder);
	$("#cascade-permissions-dialog").on("click", "button.save", saveCascadePermissions);
	$("#taxonomy-permissions-dialog").on("click", "button.save", saveTaxonomyPermissions);
	$("#more-help-link-dialog").on("click", "button.save", saveMoreHelpLink);
	$("#default-tooltip-dialog").on("click", "button.save", saveDefaultTooltip);
	$("#all-tooltip-dialog").on("click", "button.save", saveAllTooltip);
	$("#any-tooltip-dialog").on("click", "button.save", saveAnyTooltip);
	$("#search-macro-parameters-dialog").on("click", "button.save", saveSearchMacroParameters);
	
	$("#filter-category-order-dialog").on("click", "button.cancel", closeFilterCategoryOrder);
	$("#cascade-permissions-dialog").on("click", "button.cancel", closeCascadePermissions);
	$("#taxonomy-permissions-dialog").on("click", "button.cancel", closeTaxonomyPermissions);
	$("#more-help-link-dialog").on("click", "button.cancel", closeMoreHelpLink);
	$("#default-tooltip-dialog").on("click", "button.cancel", closeDefaultTooltip);
	$("#all-tooltip-dialog").on("click", "button.cancel", closeAllTooltip);
	$("#any-tooltip-dialog").on("click", "button.cancel", closeAnyTooltip);
	$("#search-macro-parameters-dialog").on("click", "button.cancel", closeSearchMacroParameters);
	
});