/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.core.util.RandomGenerator;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitZipFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;

public class AttachmentsExporter {
    public static final String ZIP_FILE_EXT = ".zip";
    protected static final String ZIP_FILE_PATTERN = "attachments-{0}{1,time,HHmmss}";
    protected String exportName;
    protected File zipFile;
    protected File exportFolder;
    protected List<String> attachmentIds;

    public List<String> getAttachmentIds() {
        return this.attachmentIds;
    }

    public AttachmentsExporter(List<String> attachmentIds) {
        this.attachmentIds = attachmentIds;
        this.exportName = MessageFormat.format(ZIP_FILE_PATTERN, RandomGenerator.randomString((int)5), new Date());
    }

    public void exportAttachments() throws Exception {
        this.initializeExport();
        for (String attachmentId : this.getAttachmentIds()) {
            Attachment attachment = Confluence.getAttachmentManager().getAttachment(BrikitNumber.parseLong(attachmentId));
            if (attachment == null) {
                BrikitLog.logWarning("Couldn't find attachment during export for attachmentId: " + attachmentId);
                continue;
            }
            if (!Confluence.canReadAttachment(attachment)) {
                BrikitLog.logWarning("User " + Confluence.getConfluenceUser() + " blocked from downloading attachment because they don't have permission to view it: " + attachment);
                continue;
            }
            this.writeAttachment(attachment);
        }
        this.finalizeExport();
    }

    protected void finalizeExport() throws Exception {
        BrikitZipFile.createZipFile(this.getExportFolder(), this.getZipFile());
        BrikitFile.removeFile(this.getExportFolder());
    }

    protected File getExportFolder() {
        if (this.exportFolder == null) {
            this.exportFolder = BrikitFile.getBrikitFile(this.getExportName());
        }
        return this.exportFolder;
    }

    public String getExportName() {
        return this.exportName;
    }

    public File getZipFile() {
        if (this.zipFile == null) {
            this.zipFile = BrikitFile.getConfluenceTempDirectoryPath(this.getExportName() + ZIP_FILE_EXT);
        }
        return this.zipFile;
    }

    protected void initializeExport() throws IOException {
        BrikitFile.removeFile(this.getZipFile());
        BrikitFile.removeFile(this.getExportFolder());
        BrikitFile.ensurePathExists(this.getExportFolder());
    }

    protected void writeAttachment(Attachment attachment) throws IOException {
        File outputFile = new File(this.getExportFolder(), attachment.getFileName());
        InputStream inputStream = Confluence.getAttachmentManager().getAttachmentData(attachment);
        if (inputStream == null) {
            BrikitLog.logWarning("Couldn't find attachment during export: " + attachment);
        } else {
            BrikitFile.writeInputStream(inputStream, outputFile);
        }
    }
}

