/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.extractor;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.model.TargetedSearch;
import java.util.Collection;
import java.util.Collections;

public class MacroParameterExtractor
implements Extractor2 {
    protected static final StringBuilder EMPTY_STRING_BUILDER = new StringBuilder(0);

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        return Collections.emptyList();
    }

    public StringBuilder extractText(Object searchable) {
        if (!(searchable instanceof AbstractPage)) {
            return EMPTY_STRING_BUILDER;
        }
        BrikitList<String> macroParameters = TargetedSearch.getSearchMacroParametersList();
        BrikitList<String> searchText = new BrikitList<String>();
        for (String spec : macroParameters) {
            BrikitList<String> bits = BrikitString.split(spec, "\\.");
            if (bits.size() != 2) {
                BrikitLog.logWarning("Macro parameter " + spec + " specified for indexing does not follow format: macro-key.parameter-name");
                continue;
            }
            String macroName = bits.first();
            String macroParam = bits.last();
            try {
                for (MacroDefinition macro : MacroParser.extractMacros((AbstractPage)searchable, macroName, macroParam)) {
                    searchText.add(MacroParser.getStringParameter(macro, macroParam));
                }
            }
            catch (XhtmlException ex) {
                BrikitLog.logError("Unable to index macro parameter " + spec + " for: " + searchable, (Exception)((Object)ex));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(searchText.join(" "));
        return builder;
    }
}

