/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.model.ArchivePolicy;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class SpaceReviewSettingsAction
extends ContentFlowActionSupport {
    protected String reviewPolicy;
    protected int reviewDays;
    protected String reviewLabel;
    protected String archivePolicy;
    protected int archiveDays;
    protected String archiveSpaceKey;

    @Override
    @PermittedMethods(value={HttpMethod.POST})
    public String execute() throws Exception {
        ContentFlowConfiguration configuration = ContentFlowConfiguration.forSpace(this.getActiveObjects(), this.getSpaceKey());
        ArchivePolicy archivePolicy = configuration.getArchivePolicy();
        if (archivePolicy == null) {
            archivePolicy = ArchivePolicy.createForSpace(this.getActiveObjects(), this.getSpaceKey());
            configuration.setArchivePolicy(archivePolicy);
            configuration.save();
        }
        archivePolicy.setReviewPolicy(this.getReviewPolicy());
        archivePolicy.setReviewDaysAfterPublished(this.getReviewDays());
        archivePolicy.setReviewLabel(this.getReviewLabel());
        archivePolicy.setArchivePolicy(this.getArchivePolicy());
        archivePolicy.setArchiveAfterDaysInReview(this.getArchiveDays());
        archivePolicy.setArchiveSpaceKey(this.getArchiveSpaceKey());
        archivePolicy.save();
        return "success";
    }

    public int getArchiveDays() {
        return this.archiveDays;
    }

    public String getArchivePolicy() {
        return this.archivePolicy;
    }

    public String getArchiveSpaceKey() {
        return this.archiveSpaceKey;
    }

    public int getReviewDays() {
        return this.reviewDays;
    }

    public String getReviewLabel() {
        return this.reviewLabel;
    }

    public String getReviewPolicy() {
        return this.reviewPolicy;
    }

    @StrutsParameter
    public void setArchiveDays(int archiveDays) {
        this.archiveDays = archiveDays;
    }

    @StrutsParameter
    public void setArchivePolicy(String archivePolicy) {
        this.archivePolicy = archivePolicy;
    }

    @StrutsParameter
    public void setArchiveSpaceKey(String archiveSpaceKey) {
        this.archiveSpaceKey = archiveSpaceKey;
    }

    @StrutsParameter
    public void setReviewDays(int reviewDays) {
        this.reviewDays = reviewDays;
    }

    @StrutsParameter
    public void setReviewLabel(String reviewLabel) {
        this.reviewLabel = reviewLabel.toLowerCase();
    }

    @StrutsParameter
    public void setReviewPolicy(String reviewPolicy) {
        this.reviewPolicy = reviewPolicy;
    }

    public void validate() {
        super.validate();
        if (!Confluence.canAdministerSpace((String)this.getSpaceKey())) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
        if (BrikitString.isSet((String)this.getReviewLabel()) && !Confluence.isValidLabelName((String)this.getReviewLabel())) {
            this.addActionError(this.getText("com.brikit.contentflow.review.label.invalid"));
        }
    }
}

