/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.model.PageStatus;
import com.brikit.contentflow.model.PageStatusContentEntity;
import com.brikit.core.util.BrikitList;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class PageStatusMetadataAction
extends ContentFlowActionSupport {
    protected Long statusKey;

    @Override
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        PageStatus status = PageStatus.getPageStatusForPage(this.getActiveObjects(), this.getPageId());
        if (status != null) {
            this.setStatusKey(Long.valueOf(status.getID()));
        }
        return super.execute();
    }

    public BrikitList<PageStatus> getStatuses() {
        return PageStatus.getAll(this.getActiveObjects());
    }

    public Long getStatusKey() {
        return this.statusKey;
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String savePageStatus() {
        if (!PageStatus.allowManualPageStatusChanges(this.getActiveObjects(), this.getPage())) {
            this.addActionError("Page status changes aren't allowed for " + this.getPage());
            return "error";
        }
        PageStatus status = PageStatus.getPageStatus(this.getActiveObjects(), this.getStatusKey());
        PageStatusContentEntity.setPageStatus(this.getActiveObjects(), this.getPageId(), status);
        return "success";
    }

    @StrutsParameter
    public void setStatusKey(Long statusKey) {
        this.statusKey = statusKey;
    }
}

