(function ($) {
	
	ContentFlowApplyDialog = function (trigger) {
		this.trigger = $(trigger);
		this.trigger.data("dialog", this);
		this.initialize();
	};
	
	Object.assign(ContentFlowApplyDialog.prototype, ContentFlowInlineDialog.prototype, {
		
		applyWorkflow: function (event) {
			var self = this;
			
			event.preventDefault();
			if (ContentFlow.pageHasContentFlow) return ContentFlow.Dialog2.alert("<p>" + ContentFlow.getText("com.brikit.contentflow.page.has.a.workflow") + "</p>", {title: ContentFlow.getText("com.brikit.contentflow.cannot.apply.title")});

			$(event.currentTarget).spin();
			ContentFlow.clickOnDialog();
			var data = { pageId: ContentFlow.pageId };
			var workflowId = $(event.target).closest("[data-workflow-id]").attr("data-workflow-id");
			data.workflowId = workflowId;
			
			//var $template = $(this).closest("[data-workflow-id]");
			//ContentFlow.isCreatingNewWorkflow = !$template.length;
			//if (!ContentFlow.isCreatingNewWorkflow) data.workflowId = $template.data("workflow-id");
			jQuery.ajax({
				url: ContentFlow.contextPath + "/plugins/contentflow/create.action",
				data: data,
				success: function (response) {
					if (ContentFlow.displayAjaxResponseError(response)) return;
					self.refreshContentFlowHolder();
				},
                error: function (xhRequest, textStatus, errorThrown) {
					// TODO:  convert error message to properties entry?
                    ContentFlow.alertError("An error occurred while applying the workflow.", errorThrown);
					$(event.currentTarget).spinStop();
					ContentFlow.refreshContentFlowHolder();
				}
			});
			
			return false;
		},
		
		getDialogOptions: function () {
			var options = {
	           width: 650  };
			   
			return options;
			
		},

		getDialogUrl: function () {
			return "/plugins/contentflow/viewworkflows.action?pageId=" + ContentFlow.getPageId();
		},
		
		getDialogUrlData: function () {
			return { };
		},
		
		initialize: function () {
		},

		initializeDialog: function () {
			var self = this;
		
			self.stopWait();

			self.dialog
				.on("click.brikit-content-flow",	 ".apply-workflow-button", 			function (e) { self.applyWorkflow(e); })
				.on("click.brikit-content-flow", 	"#close-manage-approval-button", 	function (e) { self.close(e); });
		},
		
		// Un-DRY-ish with approve-dialog. This will probably become a generic method taking the action call and optional data, so any dialog
		// can refresh from a given action 
		refreshContentFlowHolder: function () {
			var self = this;
		
			if (!self.dialog) return location.reload(true);

			ContentFlow.showWait();
			
	        jQuery.ajax({
	           	url: ContentFlow.contextPath + self.getDialogUrl(),
				data: {
					pageId: ContentFlow.getPageId()
				},
	            success: function(response) {
					ContentFlow.reloadBrowser();
	            },
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while refreshing.", errorThrown);
	            }
	        });
		}
		
	});


	ContentFlow.toFinalize(function ($) {
	});

})(jQuery);
