(function ($) {
	
	ContentFlow.Archive = {

		archivePage: function (event) {

			event.preventDefault();
			
			ContentFlow.Dialog2.confirm("<p>" + ContentFlow.getText("com.brikit.contentflow.archive.question") + "</p>", 
						{title: "Archive"}, function (dialog) {

		        jQuery.ajax({
		            url: ContentFlow.contextPath + "/plugins/contentflow/archivepage.action",
					data: {
						pageId: ContentFlow.pageId
					},
					dataType: "json",
		            success: function(response) {
						if (response.archived) location.href = response.pageURL;
						else alert(response.message);
		            },
		            error: function (xhRequest, textStatus, errorThrown) {
		                ContentFlow.alertError("An error occurred while archiving page.", errorThrown);
						dialog.enable();
						// ContentFlow.refreshContentFlowHolder();
		            }
		        });
	        });

	        return false;
	    },
		
		initialize: function () {
			$("#content-flow-archive-page").click(ContentFlow.Archive.archivePage);
			$("#content-flow-restore-page").click(ContentFlow.Archive.restoreFromArchive);
			
			$("#review-after-days-field").showForValue($("#review-option"), ["DAYS_AFTER_PUBLISHED", "DAYS_AFTER_LAST_VIEW"]);
			$("#archive-after-days-field").showForValue($("#archive-option"), "AFTER_DAYS_IN_REVIEW");
			$("#archive-to-space").showForValue($("#archive-option"), "AFTER_DAYS_IN_REVIEW");
			
		},
		
		restoreFromArchive: function (event) {

			event.preventDefault();
			
			ContentFlow.Dialog2.confirm(ContentFlow.getText("com.brikit.contentflow.restore.page.from.archive.confirmation"), 
						{title: ContentFlow.getText("com.brikit.contentflow.restore.name")}, function (dialog) {

		        jQuery.ajax({
		            url: ContentFlow.contextPath + "/plugins/contentflow/restorefromarchive.action",
					data: {
						pageId: ContentFlow.pageId
					},
					dataType: "json",
		            success: function(response) {
		                location.href = response.pageURL;
		            },
		            error: function (xhRequest, textStatus, errorThrown) {
		                ContentFlow.alertError("An error occurred while marking as reviewed.", errorThrown);
						dialog.enable();
						// ContentFlow.refreshContentFlowHolder();
		            }
		        });
	        });

	        return false;
	    }		
		
	};

	ContentFlow.toInit(ContentFlow.Archive.initialize);

})(jQuery);
