(function ($) { 

	// To simplify brikit-core, reference core javascript using BrikitCore
	var BrikitCore = this[brikitProduct];
	
	// If specified, listener may implement:
	// 	labelPickerResultsLoaded(labelPicker) - called after each search results are loaded
	// 	labelPickerLabelSelected(labelPicker, label) - called when a user selects a label in the dropdown
	BrikitCore.LabelPicker = function (labelPicker, listener) {
		this.labelPicker = $(labelPicker);
		this.listener = listener;
		this.initialize();
		
		this.debug = true;
	};
	
	Object.assign(BrikitCore.LabelPicker.prototype, {
	
		errorOccurred: function (x, s, t) {
			console.error(x);
			var data = { error: JSON.parse(x.responseText).message };
			console.error("An error occurred: " + data.error);
			this.callback(data);
		},
	
		find: function (selector) {
			return selector ? this.labelPicker.find(selector) : this.labelPicker;
		},
		
		hideResults: function (event) {
			this.labelResultsList.hide();
		},
		
		initialize: function () {
			this.labelPickerField = this.find(".label-picker-input-field");
			this.labelResultsList = this.find(".label-autocomplete-list");
			
			this.labelPickerField.on("keyup", this.queueSearch.bind(this));
			this.labelResultsList.on("click", "a", this.labelSelected.bind(this));

			$(document).click(this.hideResults.bind(this));
		},
		
		labelSelected: function (event) {
			event.preventDefault();
			event.stopPropagation();
			
			var $selection = $(event.target).closest(".label-result");
			if (this.debug) console.log("label selected", $selection);
			
			if (this.listener && this.listener.labelPickerLabelSelected) this.listener.labelPickerLabelSelected(this, $selection.text());
			
			this.hideResults();
			this.labelPickerField.val("");
		},
		
		loadResults: function (data) {

			if (this.debug) console.log("search results", data);
			
//		 <div class="aui-dropdown aui-dropdown-left">
//			 <ol></ol>
//			 <ol class="last">
//				 <li class=""><a href="#" class="label-suggestion"><span title="booking_issue"><em>booking_issue</em></span></a></li>
//			 </ol>
//		 </div>
			
			var $ol = $("<ol class='last'>");
			var $dropdown = $("<div class='aui-dropdown aui-dropdown-left'>").append($ol);
			
            const results = data.contentNameMatches[0];
			if (!results || !results.length) {
				this.hideResults();
				return;
			}
			
			$(results).each(function (i, result) {
				if (this.debug) console.log("Found: ", result.name);
				var $a = $("<a class='label-result'>")
					.attr("href", result.href)
					.attr("data-key", result.name)
					.append($("<span>").text(result.name));
				var $li = $("<li>").append($a);
				$ol.append($li);
			}.bind(this));
			
			if (this.debug) console.log(this.labelResultsList, $dropdown);
			this.labelResultsList.html($dropdown);
			this.showResults();
			
			if (this.listener && this.listener.labelPickerResultsLoaded) this.listener.labelPickerResultsLoaded(this);
		},
		
		queryString: function () {
			return this.labelPickerField.val();
		},
	
		queueSearch: function () {
	        clearTimeout(this.timer);
	        this.timer = setTimeout(this.searchCriteriaChanged.bind(this), 300);
		},

		searchCriteriaChanged: function () {

			if (!this.queryString()) return this.labelResultsList.empty();

			if (this.debug) console.log("Firing autocomplete search for label", this.queryString());
			$.ajax({
			    url: AJS.Labels.routes.index + "&query=" + this.queryString() + "&ignoreRelated=true&maxResults=10",
			    type: "GET",
			    success: this.loadResults.bind(this), 
				error: this.errorOccurred.bind(this),
			    dataType: "json"
			});

		},
		
		showResults: function () {
			this.labelResultsList.show();
		}
				
	});
	
})(jQuery);