/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.model;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.SafeId;
import jakarta.annotation.Nonnull;

public class BrowserTweakerCache {
    protected static CacheSettings cacheSettings = new CacheSettingsBuilder().remote().maxEntries(50).build();
    protected static Cache<String, String> cache;

    protected static Cache<String, String> getCache() {
        if (cache == null) {
            cache = Confluence.getCacheManager().getCache("Brikit Theme Press Browser Tweaker", (CacheLoader)new BrowserTweakerCacheLoader(), cacheSettings);
        }
        return cache;
    }

    public static synchronized String getTweaker(String key) {
        return (String)BrowserTweakerCache.getCache().get((Object)key);
    }

    public static void reset() {
        BrowserTweakerCache.getCache().removeAll();
    }

    public static void reset(String key) {
        BrowserTweakerCache.getCache().remove((Object)key);
    }

    protected static class BrowserTweakerCacheLoader
    implements CacheLoader<String, String> {
        protected BrowserTweakerCacheLoader() {
        }

        @Nonnull
        public String load(@Nonnull String cacheKey) {
            return SafeId.globalSafeId();
        }
    }
}

