/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.struts.multipart.FileUploadException;
import com.atlassian.struts.multipart.UploadedFile;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.LoadDesignerAction;
import com.brikit.themepress.settings.ThemePlugin;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class SelectImageAction
extends LoadDesignerAction {
    protected String imageName;
    protected List<String> themeImages;

    @PermittedMethods(value={HttpMethod.POST})
    public String upload() {
        UploadedFile uploadedFile;
        if (this.getMultiPartRequest() == null) {
            return "input";
        }
        try {
            uploadedFile = this.getUploadedFile();
        }
        catch (FileUploadException e) {
            List errors = this.strutsHelper.localizeStrutsMessages((Collection)e.getErrorMsgs());
            for (String message : errors) {
                this.addActionError(message);
            }
            return "error";
        }
        if (uploadedFile == null) {
            this.addActionError(this.getText("com.brikit.file.upload.failed", uploadedFile.getFileName()));
            return "error";
        }
        try {
            ImageIO.read(uploadedFile.getFile());
        }
        catch (IllegalArgumentException e) {
            this.addActionError(this.getText("com.brikit.image.read.failed"));
            BrikitFile.removeFile((File)uploadedFile.getFile());
            return "error";
        }
        catch (IOException e) {
            this.addActionError(this.getText("com.brikit.file.open.failed"));
            return "error";
        }
        File destination = ThemePlugin.getImageLocation(this.getThemeNameFromProperties(), uploadedFile.getFileName());
        try {
            BrikitFile.copy((File)uploadedFile.getFile(), (File)destination);
        }
        catch (IOException e) {
            this.addActionError(this.getText("com.brikit.file.read.failed"));
            return "error";
        }
        return "success";
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String remove() {
        File image = ThemePlugin.getImageLocation(this.getThemeNameFromProperties(), this.getImageName());
        if (image != null && image.exists()) {
            image.delete();
        }
        return "success";
    }

    public String getImageName() {
        return this.imageName;
    }

    @StrutsParameter
    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public boolean hasImageName() {
        return BrikitString.isSet((String)this.getImageName());
    }

    public List<String> getThemeImages() {
        if (this.themeImages == null) {
            this.themeImages = ThemePlugin.getImageNames(this.getThemeNameFromProperties());
        }
        return this.themeImages;
    }
}

