(function ($) {
	
	ThemePress.Code = {
		
		canExit: function () {
			return !ThemePress.Code.editorHasUnsavedChanges() || confirm("You have unsaved changed. Discard them?");
		},
		
		close: function (event, forceClose) {
			if (!ThemePress.Code.popup || !forceClose && !ThemePress.Code.canExit()) return false;
			ThemePress.Code.popup.hide();
			ThemePress.Code.popup = null;
			return false;
		},
		
		createFile: function () {
			if (!ThemePress.Code.canExit()) return false;
			ThemePress.Code.close(false, true);
            const $form = $("<form id='create-file-form' class='aui' onsubmit='return false;'><fieldset><div class='field-group'><label for='new-file-name'>New File Name</label> <input id='new-file-name' name='filename' class='text' type='text' /><div class='description'>Spaces are not allowed.</div></div><input type='hidden' name='fileExtension' value='" + ThemePress.Code.fileExtension + "' /><input type='hidden' name='themeName' value='" + ThemePress.currentTheme() + "' /></fieldset></form>");
            const $contents = $("<div/>");
            $contents.append($form);
            $contents.append($("<br/><p>(Note: custom code may need rework during software upgrades.)</p>"));
			ThemePress.Dialog2.confirm($contents, { title: "New " + ThemePress.Code.fileDescription() + " File" }, function (dialog) {
				var newFileName = $.trim($("#new-file-name").val());
				if (/\s/g.test(newFileName)) {
					alert("Spaces are not allowed in file names.");
					return false;
				}
				dialog.hide();
				ThemePress.post(
					ThemePress.contextPath + "/plugins/brikit/theme/createfile.action", 
					$("#create-file-form").serialize(), 
					function (data, textStatus, jqXHR) {
						if (data.success) {
							ThemePress.Code.focusFile = data.filename;
							ThemePress.Code.reopenFileViewer();
							// ThemePress.Designer.reloadDesigner();
						}
						else {
							alert("Failed to create file.");
						}
					}, 
					"json"
				);
			});
			return false;
		},

		currentEditor: function () {
			return $(ThemePress.Code.isCSS() ? ".css-editor" : ".js-editor");
		},

		editFile: function () {
			
			if ($(this).hasClass("selected") || !ThemePress.Code.canExit()) return;
			
			ThemePress.Code.selectedFile().removeClass("selected");
			$(this).addClass("selected");
			// <span class="aui-progress-indicator-value"></span>
			ThemePress.Code.currentEditor().find(".placeholder, textarea, .CodeMirror").remove();
			ThemePress.Code.currentEditor().append($("<div>").addClass("placeholder waiting"));
			ThemePress.Code.focusFile = ThemePress.Code.filename(this);
            const data = {themeName: ThemePress.currentTheme(), fileExtension: ThemePress.Code.fileExtension, filename: ThemePress.Code.focusFile};
            ThemePress.post(ThemePress.contextPath + "/plugins/brikit/theme/editfile.action", 
					data, 
					ThemePress.Code.loadEditor);
		},
		
		editorHasUnsavedChanges: function () {
			return ThemePress.Code.codeMirror &&
				ThemePress.Code.popup.popup.find(".code-file-list .file.selected").length &&
				ThemePress.Code.codeMirror.getValue() != ThemePress.Code.currentEditor().find("textarea.file-contents").val();
		},
		
		editorValue: function () {
			return ThemePress.Code.codeMirror ? ThemePress.Code.codeMirror.getValue() : null;
		},
		
		fileDescription: function () {
			return ThemePress.Code.isCSS() ? "CSS" : "JavaScript";
		},
		
		filename: function (selected) {
			return $(selected).closest(".file").data("filename");
		},

		initFileViewer: function (fileExtension) {
			ThemePress.Code.popup = this;
			var $popup = $(this.popup);
			$popup.css({zIndex: 10000});
			
			$popup.draggable({
				handle: ".drag-handle",
				cursor: "move",
				delay: 150,
				distance: 10,
				zIndex: 20000
			});

			ThemePress.Code.fileExtension = fileExtension;

			// Make the tooltips use the fancy AUI decoration
			$(".file, a", $popup).tooltip({aria:true});

			// Wire the "remove" icons
			$(".code-file-list .file .remove").click(ThemePress.Code.removeFile);
			
			// Wire the css icons to load the corresponding file into the editor
			$(".code-file-list .file").click(ThemePress.Code.editFile);
			
			// Wire the download and new file button
			$(".manage-files .new").click(ThemePress.Code.createFile);
			// $(".manage-files .download").click(ThemePress.Code.download);

			$(".manage-files .close").click(ThemePress.Code.close);
			$(".manage-files .save").click(ThemePress.Code.save);

			// Wire the upload file button
			ThemePress.Code.uploaderInit($popup);
			
			// Focus on the last file
			// if (ThemePress.Code.focusFile) $(".code-file-list .file[data-filename='" + ThemePress.Code.focusFile + "']").click();
			
		},
		
		isCSS: function () {
			return ThemePress.Code.fileExtension == "css";
		},
		
		loadEditor: function (data, textStatus, jqXHR) {
			$(".placeholder", ThemePress.Code.currentEditor()).remove();
			ThemePress.Code.currentEditor().append(data);
			var css = ThemePress.Code.isCSS();
			ThemePress.Code.codeMirror = CodeMirror.fromTextArea(ThemePress.Code.currentEditor().find("textarea").get(0), { 
				mode: css ? "css" : "javascript", 
				tabSize: css ? 2 : 4, matchBrackets: true 
			});
		},
		
		removeFile: function () {
			if (!ThemePress.Code.canExit()) return false;
			ThemePress.Code.close(false, true);
			
			var $this = $(this);
			var filename = ThemePress.Code.filename(this);

			var proceedCallback = function (dialog) {
                const data = {themeName: ThemePress.currentTheme(), filename: filename, fileExtension: ThemePress.Code.fileExtension};
                ThemePress.post(
					ThemePress.contextPath + "/plugins/brikit/theme/removefile.action", 
					data, 
					function (result, textStatus, jqXHR) {
						if (result.success) ThemePress.Designer.forceReload();
						else ThemePress.Dialog2.alert(result.error || "Failed to remove file.", {title: "Remove Error"}, ThemePress.Designer.forceReload);
					}, 
					"json"
				);
			};

			ThemePress.Dialog2.doubleConfirm("<p>Delete " + filename + "." + ThemePress.Code.fileExtension + "?</p>", { title: "Delete", doubleConfirmMessage: "I understand this action is permanent." }, proceedCallback);
			return false;
		},
		
		reopenFileViewer: function () {
			ThemePress.Designer.designer("." + (ThemePress.Code.isCSS() ? "css-editor-link" : "js-editor-link")).click();
		},
		
		save: function () {
			if (!ThemePress.Code.editorHasUnsavedChanges()) return false;
			
            const data = {themeName: ThemePress.currentTheme(), filename: ThemePress.Code.focusFile, fileExtension: ThemePress.Code.fileExtension, fileContents: ThemePress.Code.editorValue()};
            ThemePress.post(
				ThemePress.contextPath + "/plugins/brikit/theme/savefile.action", 
				data, 
				function (data, textStatus, jqXHR) {
					if (data.success) {
						ThemePress.Designer.forceReload();
					}
					else {
						ThemePress.Dialog2.alert(data.error || "Failed to save file.", {title: "Save Error"}, ThemePress.Designer.forceReload);
					}
				}, 
				"json"
			);
		},
		
		selectedFile: function () {
			return $(".code-file-list .file.selected");
		},
		
		showCSS: function (event) {
			if (ThemePress.Code.popup) return false;
			ThemePress.Code.cssDialog.show();
		},
	
		showJavascript: function (event) {
			if (ThemePress.Code.popup) return false;
			ThemePress.Code.javascriptDialog.show();
		},
	
		uploaderInit: function ($popup) {
			// Make the upload button trigger the hidden file upload form
			$(".manage-files .upload").click(function () {
				$("form.uploader .upfile", $popup).val("").click();
				return false;
			});

			// When the file upload filename changes, automagically upload the file
			$("form.uploader .upfile", $popup).change(function () { 
				// On submission of the theme uploader, confirm before firing
				var $form = $(this).closest("form.uploader");
				var fileName = $("form.uploader .upfile", $popup).val().split('\\').pop();
				var dotExt = "." + ThemePress.Code.fileExtension;
				if (!ThemePress.endsWith(fileName, dotExt)) {
					ThemePress.Dialog2.alert("<p>Only " + dotExt + " files can be uploaded.</p>", { title: "Invalid File Type" });
					return false;
				}
				$form.submit();
			});
			
			// On submission of the theme uploader, check server response for errors, and set the new theme if successful
			// Make the file upload form work via ajax (using the jquery.form plugin)
			$("form.uploader", $popup).ajaxForm({
				success: function (data, textStatus, jqXHR) {
						if (data.success) {
							ThemePress.Designer.forceReload();
						}
						else {
							alert("Failed to create file.");
						}
					}, 
				dataType: "json"
			});
		},
		
		viewCSSFiles: function () {
			$(this).click(ThemePress.Code.showCSS);
			ThemePress.Code.cssDialog = AJS.InlineDialog(
				$(this), 
				"edit-dialog-css",
				ThemePress.contextPath + "/plugins/brikit/theme/viewfiles.action?themeName=" + encodeURIComponent(ThemePress.currentTheme()) + "&fileExtension=css", 
				ThemePress.Code.viewFilesOptions("css")
			);
		},
		
		viewFilesOptions: function (mode) {
			return {
				onHover: false, 
				width: Math.min($(window).width() - 240, $(window).width() * .8),
				hideDelay: null,
				persistent: true,
				noBind: true,
				calculatePositions: function (popup, targetPosition, mousePosition, opts) {
				        var targetOffset = targetPosition.target.offset();
				        var popupCss = {
				                top: 20 + $("body").scrollTop(),
				                left: ($(window).width() - popup.width()) / 2,
				                right: "auto"
				        };

				        var arrowCss = {
				                display: "none" // I don't actually want to show the arrow now
				        };

				        return {
				            displayAbove: false,
				            popupCss: popupCss,
				            arrowCss: arrowCss
				        };
				    },
				showDelay: 0, 
				cacheContent: false,
				// hideCallback: function (popup) { return false; },
				initCallback: function () { ThemePress.Code.initFileViewer.call(this, mode); }
			};
		},

		viewJavascriptFiles: function () {
			$(this).click(ThemePress.Code.showJavascript);
			ThemePress.Code.javascriptDialog = AJS.InlineDialog(
				$(this), 
				"edit-dialog-js",
				ThemePress.contextPath + "/plugins/brikit/theme/viewfiles.action?themeName=" + encodeURIComponent(ThemePress.currentTheme()) + "&fileExtension=js",
				ThemePress.Code.viewFilesOptions("js")
			);
		}
		
	};
	
})(jQuery);
