(function ($) { 

	ThemePress.PresentationMode = {
		
		// mouseMoved: false,
		// lastMotion: false,
		watching: false,
		presenterNotesWindow: false,
		
		checkCursorState: function () {
			if (ThemePress.PresentationMode.isPresentationMode()) $("body").addClass("hide-mouse");
		},
		
		initialize: function () {
			$(document).keydown(ThemePress.PresentationMode.keyDown)
					   .mousemove(ThemePress.PresentationMode.mouseMoved);
		},
		
		isMouseHidden: function () {
			return $("body.hide-mouse").length;
		},
		
		isPresentationMode: function () {
			return $("body.presentation-mode").length;
		},
		
		keyDown: function (event) {
			if (!ThemePress.PresentationMode.isPresentationMode()) return;
			
			var keydown = event.which;

			// ESC key ends presentation mode
			if (keydown == 27) {
				event.preventDefault();
				ThemePress.PresentationMode.off();
			}
			// Up arrow, right arrow, or space key moves to the next page
			else if (keydown == 32 || keydown == 39 || keydown == 40) {
				event.preventDefault();
				location.href = ThemePress.contextPath + "/brikit/pages/nextpage.action?pageId=" + ThemePress.pageId;
			}
			// Down arrow or left arrow moves to the previous page
			else if (keydown == 37 || keydown == 38) {
				event.preventDefault();
				location.href = ThemePress.contextPath + "/brikit/pages/previouspage.action?pageId=" + ThemePress.pageId;
			}
			// N key opens present notes
			else if (keydown == 78) {
				event.preventDefault();
				ThemePress.PresentationMode.openPresenterNotes();
			}
		},

		mouseMoved: function (event) {
			if (!ThemePress.PresentationMode.isPresentationMode()) return;
			
			ThemePress.PresentationMode.startWatching();
			$("body").removeClass("hide-mouse");
		},
		
		off: function (event) {
			$("body").removeClass("presentation-mode hide-mouse");
			ThemePress.PresentationMode.stopWatching();
			ThemePress.Structure.structureDidChange();
		},
		
		on: function () {
			$("body").addClass("presentation-mode hide-mouse");
			ThemePress.PresentationMode.startWatching();
		},
		
		openPresenterNotes: function () {
			var $notes = $(".presentation-notes .brikit-content-block");
			if ($notes.length) {
				var url = ThemePress.contextPath + "/pages/viewpage.action?pageId=" + ThemePress.pageId + "&presentationNotes=true";
				var presenterWindow = window.open(url, "presenter-window", "titlebar=no,menubar=no");
			}
		},
		
		startWatching: function () {
			ThemePress.PresentationMode.stopWatching();
			ThemePress.PresentationMode.watching = setTimeout(ThemePress.PresentationMode.checkCursorState, 3000);
		},

		stopWatching: function () {
			clearTimeout(ThemePress.PresentationMode.watching);
		},
		
		viewPresenterNotes: function () {
			$(".brikit-content-stack").html($(".brikit-content-stack", opener.document).html());
			$(".brikit-content-layer:not(.presentation-notes)").remove();
			$(".presentation-notes").show().find(".brikit-content-block").html($(".presentation-notes .brikit-content-block", opener.document).html());
			setTimeout(ThemePress.PresentationMode.viewPresenterNotes, 1000);
		}
	
	};
	
})(jQuery);

// Detect and apply presentation mode
ThemePress.toInit( function ($) {
	ThemePress.PresentationMode.initialize();
	ThemePress.clickOnDocument();
});
