/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.ClassLoaderUtils;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.theme.ThemeResourceServlet;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.settings.BrikitThemeSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class PopupHelpAction
extends ConfluenceActionSupport {
    public static final String KEY_ROOT = "com.brikit.designer.setting.";
    public static final String IMAGES_SUFFIX = ".images";
    public static final String EXAMPLE_SUFFIX = ".example";
    public static final String CSS_PROPERTY_SUFFIX = ".css";
    public static final String ERROR_SUFFIX = ".error";
    public static final String WARNING_SUFFIX = ".warning";
    public static final String SUCCESS_SUFFIX = ".success";
    public static final String HINT_SUFFIX = ".hint";
    public static final String DEFAULT_IMAGE_TYPE = ".png";
    public static final String HELP_PAGE = ".help.page";
    public static final String SUPPRESS_PROPERTIES = ".suppress.properties";
    public static final String TOUR_NAME = ".lesson-plan";
    public static final String TOUR_BUTTON_TEXT = ".lesson-plan.button.text";
    public static final String IMAGE_FILE_LOCATION = "images/theme-designer/help/";
    protected String name;
    protected String key;
    protected List<String> args;

    protected String getCaption(String imageName) {
        return this.getValueIfSpecified(this.getKeyWithRoot() + IMAGES_SUFFIX + "." + imageName);
    }

    public String getExample() {
        return this.getValueIfSpecified(this.getKeyWithRoot() + EXAMPLE_SUFFIX);
    }

    public String getCssProperty() {
        return this.getValueIfSpecified(this.getKeyWithRoot() + CSS_PROPERTY_SUFFIX);
    }

    public String getError() {
        return this.getValueIfSpecified(this.getKeyWithRoot() + ERROR_SUFFIX);
    }

    public String getWarning() {
        return this.getValueIfSpecified(this.getKeyWithRoot() + WARNING_SUFFIX);
    }

    public String getSuccess() {
        return this.getValueIfSpecified(this.getKeyWithRoot() + SUCCESS_SUFFIX);
    }

    public String getHint() {
        return this.getValueIfSpecified(this.getKeyWithRoot() + HINT_SUFFIX);
    }

    public String getFormattedMessage() {
        return this.getValueIfSpecified(this.getKeyWithRoot());
    }

    public String getHelpPage() {
        String helpPage = this.getValueIfSpecified(this.getKeyWithRoot() + HELP_PAGE);
        return BrikitString.isSet((String)helpPage) ? GeneralUtil.urlEncode((String)helpPage) : null;
    }

    protected String getImageListValue() {
        return this.getValueIfSpecified(this.getKeyWithRoot() + IMAGES_SUFFIX);
    }

    public List<List> getImageNamesWithCaptions() {
        BrikitList imageNames = BrikitString.splitCommaSeparated((String)this.getImageListValue());
        if (imageNames.isEmpty()) {
            imageNames.add(this.getKey() + DEFAULT_IMAGE_TYPE);
        }
        ArrayList<List> namesWithCaptions = new ArrayList<List>();
        for (String imageName : imageNames) {
            if (!this.imageExists(imageName)) continue;
            String caption = this.getCaption(imageName);
            namesWithCaptions.add(Arrays.asList(imageName, caption == null ? "" : caption));
        }
        return namesWithCaptions;
    }

    public String getKeyWithRoot() {
        return KEY_ROOT + this.getKey();
    }

    public String getTourName() {
        return this.getValueIfSpecified(this.getKeyWithRoot() + TOUR_NAME);
    }

    public String getTourButtonText() {
        return this.getValueIfSpecified(this.getKeyWithRoot() + TOUR_BUTTON_TEXT);
    }

    public String getValueIfSpecified(String key) {
        if (!BrikitString.isSet((String)key)) {
            return null;
        }
        String value = Confluence.getText((String)key);
        return BrikitString.isSet((String)value) && !key.equals(value) ? Confluence.getText((String)key, this.getArgs()) : null;
    }

    public boolean getBooleanValue(String key) {
        return BrikitBoolean.booleanValue((String)this.getValueIfSpecified(key));
    }

    public boolean imageExists(String imageName) {
        String resourcePath = IMAGE_FILE_LOCATION + imageName;
        String filePath = ThemeResourceServlet.getServerFileLocation((String)resourcePath);
        return ExternalDevelopmentMode.isDeveloperMode() ? new File(filePath).exists() : ClassLoaderUtils.getResource((String)filePath, BrikitThemeSettings.class) != null;
    }

    public boolean suppressProperties() {
        return this.getBooleanValue(this.getKeyWithRoot() + SUPPRESS_PROPERTIES);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @StrutsParameter
    public void setArgs(List<String> args) {
        this.args = args;
    }

    @StrutsParameter
    public void setKey(String key) {
        this.key = key;
    }

    @StrutsParameter
    public void setName(String name) {
        this.name = name;
    }
}

