/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.html;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.themepress.html.RichLinkContent;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class RichLinkContentCache {
    protected static Cache<String, RichLinkContent> cache;

    protected static Cache<String, RichLinkContent> getCache() {
        if (cache == null) {
            CacheSettingsBuilder builder = new CacheSettingsBuilder().remote().expireAfterAccess(30L, TimeUnit.DAYS).maxEntries(10000);
            cache = Confluence.getCacheManager().getCache(Confluence.getText("com.brikit.themepress.rich.link.content.cache"), (CacheLoader)new RichLinkContentCacheLoader(), builder.build());
        }
        return cache;
    }

    public static RichLinkContent getRichLinkContent(AbstractPage abstractPage) {
        if (!Confluence.canRead(abstractPage)) {
            return null;
        }
        String url = Confluence.getUrlPath((ContentEntityObject)abstractPage);
        return (RichLinkContent)RichLinkContentCache.getCache().get((Object)url);
    }

    public static RichLinkContent getRichLinkContent(String url) {
        AbstractPage abstractPage = Confluence.getPageForUrl(url);
        return abstractPage != null ? RichLinkContentCache.getRichLinkContent(abstractPage) : (RichLinkContent)RichLinkContentCache.getCache().get((Object)url);
    }

    public static void reset() {
        RichLinkContentCache.getCache().removeAll();
    }

    public static void reset(AbstractPage abstractPage) {
        RichLinkContentCache.getCache().remove((Object)Confluence.getPageURL(abstractPage));
    }

    protected static class RichLinkContentCacheLoader
    implements CacheLoader<String, RichLinkContent> {
        protected RichLinkContentCacheLoader() {
        }

        @Nonnull
        public RichLinkContent load(@Nonnull String url) {
            AbstractPage abstractPage = Confluence.getPageForUrl(url);
            return abstractPage != null ? RichLinkContent.get(abstractPage) : RichLinkContent.wget(url);
        }
    }
}

