(function ($) { 

	TargetedSearchLabels = function () {
		this.isSpaceLabels = false;
		this.isSpaceOverview = false;
		this.labelsToFilters = {};
		this.cascadingLabels = {};
		// This gets initialized by SearchPanel after fetching basic info from server
		
		this.debug = false;
	};
	
	Object.assign(TargetedSearchLabels.prototype, {
	
		addFilterContainerToLabelsDialog: function () {
			
			// Wait until the dialog appears
			if (!this.findAddLabelForm().is(":visible")) {
				if (this.debug) console.log("Waiting for add label form to appear");
				return setTimeout(this.addFilterContainerToLabelsDialog.bind(this), 50);
			}

			if (this.filterContainer.hasClass("added-to-dialog")) {
                this.markSelectedLabels();
                this.updateFilterVisibility();
			}
            else {
				this.disableFolksonomy();
				this.addFolksonomyLinkToFilterContainer();

				// Add the filters container to the Confluence labels editor
		   		this.findAddLabelForm().after(this.filterContainer.addClass("added-to-dialog"));
			
				if (this.findAddLabelForm().hasClass("targeted-search-initialized")) return;
				this.findAddLabelForm().addClass("targeted-search-initialized");

                this.markSelectedLabels();

				// Bind the filter selectors:
				this.filterContainer.on("click", ".filter-name", this.applyFilter.bind(this));
				
				if (this.canCascade) this.filterContainer.on("contextmenu", ".filter-name", this.applyCascadingLabel.bind(this));
			
				// When labels are removed, wait for the animation before updating the filter list or the removal won't be detected
				this.findAddLabelForm().on("click", ".aui-label-split-close", this.removeFilter.bind(this));
			}
			
			this.sizeDialogHeightToFitWindow();
			
		},

		addFiltersToSpaceCategories: function () {

		    if (!this.isSpaceLabels || this.isSpaceLabels) return;

            // Add the available filter options to the Confluence labels editor
            $("#space-tools-body").append(this.filterContainerCopy());

            // Bind the filter selectors:
            this.filterContainer.on("click", ".filter", function () {
                $("#newTeamLabel").val($(this).data("filter").label);
                $("form.edit-space-details").submit();
                return false;
            });

            // When labels are removed, wait for the animation before updating the filter list or the removal won't be detected
            $("#space-categories-list").on("click", ".aui-label-split-close", function () {
                setTimeout(this.updateWatcher.bind(this), 750);
            });
        },
		
		addFolksonomyLinkToFilterContainer: function () {
			var $addLink = $("<a>")
				.attr("id", "add-folksonomy-label")
				.attr("href", TargetedSearch.contextPath + "/plugins/targetedsearch/addfolksonomy.action")
				.text(TargetedSearch.getText("com.brikit.targetedsearch.settings.dialog.add.folksonomy"))
				.click(this.applyFolksonomyLabel.bind(this));
			
			this.labelSearchField().after($addLink).after(" ");
		},
        
		addInheritedLabelsToPage: function () {
            var self = this;
            
            // Only add inherited labels if we're looking at labels associated with a page
            if (this.cascadingLabelHelpPanel) this.cascadingLabelHelpPanel.showIf(this.isLabelingPage());
            
            const inheritedLabels = this.inheritedLabels;
            if (this.debug) console.log("Adding inherited labels to display: ", inheritedLabels);
            $("[entitytype=page] .label-list").each(function () {
    			var $labelsContainer = $(this);
                // Skip if we're dealing with attachments
                if ($labelsContainer.closest(".attachments").length) return;
                
                var isRichLink = $labelsContainer.closest(".rich-link-labels").length;

    			var $labelPicker = $("#dialog-label-list .label-list");
    			$.each(inheritedLabels, function (i, filter) {
    				// <li class="aui-label " data-label-id="69074949"><a class="aui-label-split-main" href="/label/nuvo/brown-bag" rel="tag">Brown Bag Series</a></li>
    				var $a = $("<a class='aui-label-split-main'>")
    					.attr("href", TargetedSearch.contextPath + "/label/" + TargetedSearch.spaceKey + "/" + filter.label)
    					.text(filter.displayString);
    				var $li = $("<li class='aui-label inherited-label'>")
    					.data("filter", filter)
    					.append(isRichLink ? filter.displayString : $a);
                    let labelClass = "label-" + filter.label;
                    if (isRichLink) $li.addClass(labelClass);
                    else $li.attr("title", TargetedSearch.getText("com.brikit.targetedsearch.inherited.label"));

    				var existingLabel = ".aui-label-split-main[href$='/" + filter.label + "']";
    				if (!$(existingLabel, $labelsContainer).length && !$("." + labelClass, $labelsContainer).length) $labelsContainer.append($li);
    				if (self.isLabelingPage() && !$(existingLabel, $labelPicker).length) $labelPicker.append($li.clone(true));
				
    				$labelsContainer.find(".no-labels-message").remove();
				
    			}.bind(this));
            });
		},
		
		addToLabelsToFiltersMap: function (filterGroups) {
			$.each(filterGroups, function (i, filterGroup) {
				$.each(filterGroup.filters, function (i, filter) {
					this.labelsToFilters[filter.label] = filter;
					this.addToLabelsToFiltersMap(filter.subcategories);
				}.bind(this));
			}.bind(this));
		},
		
		applyCascadingLabel: function (event) {
			this.applyFilterWithHierarchy(event, true);
		},

		applyFilter: function (event) {
			this.applyFilterWithHierarchy(event, false);
		},
		
		applyFilterWithHierarchy: function (event, cascadeLabel) {
            
            // Ignore cascading label requests unless we're on a page
            if (cascadeLabel && !this.isLabelingPage()) return true;
            
			event.preventDefault();
			var $filter = $(event.currentTarget).closest(".filter");
			
			if ($filter.hasClass("selected")) return;
			
			var filter = $filter.data("filter");
			if (cascadeLabel && !confirm(TargetedSearch.getText("com.brikit.targetedsearch.label.picker.cascade.label.confirm", [filter.displayString, filter.label]))) return;
			
			$filter.addClass("selected");

			// Walk up the hierarchy to ensure all parent category filters are applied
			var addLabels = [ $filter.data("filter").label ];
			$filter.parents(".filter").each(function (i, filter) { addLabels.push($(filter).data("filter").label); $(filter).addClass("selected") });
			var addLabelsString = addLabels.reverse().join(" ");

			if (cascadeLabel) {
				this.cascadingLabels = this.cascadingLabels.concat(addLabels);

                const data = { pageId: TargetedSearch.pageId, labels: addLabelsString };
                TargetedSearch.addToken(data);
                
				$.post(
                    TargetedSearch.contextPath + "/plugins/targetedsearch/addcascadinglabel.action", 
                    data,
					function () {
						AJS.Labels.addLabel(addLabelsString, this.entityId(), this.entityType());
						setTimeout(this.updateWatcher.bind(this), 750);
					}.bind(this)
				);
			}
			else {
				AJS.Labels.addLabel(addLabelsString, this.entityId(), this.entityType());
				setTimeout(this.updateWatcher.bind(this), 750);
			}
			
		},

		applyFolksonomyLabel: function (event) {
			event.preventDefault();
			var $link = $(event.target);

			var label = $.trim(this.labelSearchField().val());
			var data = {
				pageId: TargetedSearch.pageId, 
				label: label
			};
            TargetedSearch.addToken(data);
			var url = $link.attr("href");
			$.post(url, data, function (response, textStatus, jqXHR) {
				response = $.parseJSON(response);
				if (response.error) TargetedSearch.Dialog2.alert(response.error, { title: TargetedSearch.getText("com.brikit.targetedsearch.error") });
				else AJS.Labels.addLabel(label, this.entityId(), this.entityType());
				this.updateFilterVisibility();
			}.bind(this));
		},
		
		disableFolksonomy: function () {
			// Leave the label search default behavior, but add a placeholder text and filter the displayed taxonomy
			this.labelSearchField()
				.keyup(this.updateWatcher.bind(this))
				.attr("placeholder", TargetedSearch.getText("com.brikit.targetedsearch.settings.dialog.search.placeholder"));
				
			// Remove the Add button and disable the form (the new Add Label link will perform the label add, and track the label in the folksonomy)
			this.getAddLabelButton().remove();
			this.findAddLabelForm().unbind("submit").submit(function (e) { e.preventDefault(); return false; });
		},
		
		entityId: function () {
			return $("#dialog-label-list").attr("entityid");
		},

		entityType: function () {
			return $("#dialog-label-list").attr("entitytype");
		},

		findAddLabelForm: function (selector) {
			var $form = $("#add-labels-form");
			return selector ? $(selector, $form) : $form;
		},
		
		findFilterByLabel: function (label) {
			return this.findInFilters(".filter[data-label='" + label + "']");
		},
		
		findInFilters: function (selector) {
			return selector ? this.filterContainer.find(selector) : this.filterContainer;
		},
		
		getAddLabelButton: function () {
			return $("#add-labels-editor-button");
		},
        
        humanizeLabel: function (label) {
            let filter = this.labelsToFilters[label];
            return filter ? filter.displayString : label;
        },
		
		// Humanize the displayed labels, and flag cascading labels
		humanizeLabels: function () {
			this.addInheritedLabelsToPage();
			
			this.labelsToHumanize().each(function (index, element) {
				var $element = $(element);
				var label = $element.text();
                var filter = $element.data("filter");
				if (!filter) {
				    filter = this.labelsToFilters[label];
    				if (this.debug && filter) console.log("Humanizing label:", label, filter);
                    if (filter) $element.text(filter.displayString).data("filter", filter);
				}
				
				if (this.cascadingLabels.includes(label) && $element.is("[href$='/" + label + "']")) {
					var $auiLabel = $element.closest(".aui-label");
					$auiLabel
						.addClass("cascading-label")
						.attr("title", TargetedSearch.getText("com.brikit.targetedsearch.cascading.label"));
					if (!this.canCascade) {
						$auiLabel.removeClass("aui-label-closeable").find(".aui-label-split-close").remove();
					}
				}
			}.bind(this));
		},

		initialize: function () {
			
			this.addToLabelsToFiltersMap(TargetedSearch.basicInfo.filterGroups);
			this.filterGroups = TargetedSearch.basicInfo.filterGroups;
			this.canCascade = TargetedSearch.basicInfo.canCascade;
			this.cascadingLabels = TargetedSearch.basicInfo.cascadingLabels;
			this.inheritedLabels = TargetedSearch.basicInfo.inheritedLabels;
			
		    if (window.location.pathname.indexOf('viewspacesummary.action') != -1) {
		        this.isSpaceOverview = true;
		        this.humanizeLabels();
		        return;
		    }

		    if (window.location.pathname.indexOf('editspacelabels.action') != -1) {
		        // Editing space categories
		        this.isSpaceLabels = true;
		        this.addFiltersToSpaceCategories();
		    }
		    else {
				this.initializeFilterContainer();
				
				this.filterLabels = new TargetedSearch.FilterLabels(this.filterPicker, true);

			    $(document).on("click", ".show-labels-editor, #rte-button-labels", this.addFilterContainerToLabelsDialog.bind(this));
			    this.humanizeLabels();
			}
			
			// Update filter state on each ajax return
            $(document).ajaxComplete(function () { this.updateWatcher(0); }.bind(this));
			
			if (ThemePress) ThemePress.Events.addCallback("labelsDidLoad", this.humanizeLabels.bind(this));
		},
		
		initializeFilterContainer: function () {
			
			this.filterContainer = $("<div class='targeted-search-filter-container'>");
			
			if (this.canCascade) {
				this.cascadingLabelHelpPanel = AJS.messages.info(this.filterContainer, {
				    body: TargetedSearch.getText("com.brikit.targetedsearch.cascading.label.help")
				});
			}
			
			// var $folksonomy = this.generateFilterGroup(TargetedSearch.getText("com.brikit.targetedsearch.settings.dialog.folksonomy.heading"), "folksonomy");
			// this.filterContainer.append($folksonomy.hide());
			
			this.filterPicker = $("<ul class='brikit-filter-picker'>");
			this.filterContainer.append(this.filterPicker);
			
		},
		
		isFilterContainerShowing: function () {
			return this.filterContainer.is(":visible");
		},
		
        // Return true if the current labels editor panel is opening for a page
        isLabelingPage: function () {
            return this.findAddLabelForm("#dialog-label-list[entitytype=page]").length;
        },
		
		labelSearchField: function () {
			return $("#labels-string");
		},
		
		labelsListInEditor: function () {
			return $(this.isSpaceLabels ? "#space-categories-list .label-list" : "#dialog-label-list .label-list");
		},

		labelsListsOnEntirePage: function () {
			return $(".label-list", this.isSpaceLabels ? "#space-categories-list" : "#dialog-label-list, .labels-section-content");
		},
		
		labelsToHumanize: function () {
			return this.isSpaceOverview ? $(".label") : $(".aui-label-split-main", this.labelsListsOnEntirePage());
		},
		
		// Mark the filters as selected for existing labels
        markSelectedLabels: function () {
          this.findInFilters(".filter.selected").removeClass("selected");
      
			$(".aui-label", this.labelsListInEditor()).each(function (i, lozenge) {
				var label = $("a", lozenge).attr("href").split("/").pop();
				this.findFilterByLabel(label).addClass("selected");
			}.bind(this));
        },
		
		// Remove the label from my page and my cascading labels list
		removeFilter: function (event) {
			var $lozenge = $(event.currentTarget).closest(".aui-label");
			var $filter = $lozenge.find(".aui-label-split-main").data("filter");
			var label = $filter.label;
			if (this.debug) console.log("Removing label:", $lozenge, $filter, label);
			
			// Check for children labels in the hierarchy and block deletion if a child is found
			var $appliedLabels = $lozenge.closest("#dialog-label-list").find(".aui-label");
			var appliedLabels = $appliedLabels
                .filter(function () { return $(this).find(".aui-label-split-main").data("filter") })
                .map(function () { return $(this).find(".aui-label-split-main").data("filter").label; }).get();
			var moreSpecificLabel = false;
			$.each($filter.subcategories, function (i,c) { 
				$.each(c.filters, function (i, f) { 
					if (this.debug) console.log(f.label, appliedLabels.indexOf(f.label));
					if (appliedLabels.indexOf(f.label) > -1) moreSpecificLabel = f.displayString; 
				}.bind(this));
			}.bind(this));
			if (moreSpecificLabel) {
				event.preventDefault();
				event.stopPropagation();
				alert(TargetedSearch.getText("com.brikit.targetedsearch.remove.more.specific.label", $filter.displayString, moreSpecificLabel));
				return false;
			}
			
			var index = this.cascadingLabels.indexOf(label);
			if (index != -1) this.cascadingLabels.splice(index, 1);
			
			this.findFilterByLabel(label).removeClass("selected");
		
			setTimeout(this.updateWatcher.bind(this), 750);
		},
				
		sizeDialogHeightToFitWindow: function () {

			// Remember the original height before we start messing with it
			var $dialog = $("#edit-labels-dialog");
			var $dialogBody = $(".dialog-panel-body", $dialog);
			
			// Stop if no filters were added
			if (!this.findInFilters(".filter-group").length) return;
			
			// If no height function detected on the filters, then dialog is still initializing, so try again in a moment
			if (!this.filterContainer.height) return setTimeout(this.sizeDialogHeightToFitWindow.bind(this), 50);

			// Now that the labels are visible, humanize them and adjust visibility before doing height calculations
			this.humanizeLabels();
			this.updateFilterVisibility(0);

			// Allow the dialog to size naturally
			$dialog.css({height: "auto"});
			$(".dialog-page-menu", $dialog).css({height: "auto"});
		
			// Limit the dialog height so as to leave 160px of the window showing
            var originalHeight = this.originalDialogHeight || $dialogBody.outerHeight();
			this.originalDialogHeight = originalHeight;
			var available = $(window).height() - originalHeight - 200;
			// If more filter groups are available to show, make the window full height
			var needed = this.filterLabels.hasMoreFilterGroups() ? available : this.filterContainer.height();
			var adjustment = Math.min(available, needed);
			var newHeight = originalHeight + adjustment;
			$dialogBody.height(newHeight);

			// Top position is 50%, so back up half the extra height to vertically center it
			var newTop = -125 - adjustment / 2;
			$dialog.css({marginTop: newTop});
		},
		
		// Adjust the filters available for selection based on the current page labels
		updateFilterVisibility: function (speed) {
			// var speed = typeof(speed) == "undefined" ? "fast" : speed;

			if (!this.isFilterContainerShowing()) {
				this.updatingFilters = false;
				return;
			}

			this.humanizeLabels();

			this.updatingFilters = false;
			
		},
		
		// If the updateFilterVisibility function is running, wait a bit and try again
		updateWatcher: function (speed) {
			if (this.updatingFilters) {
				clearTimeout(this.updatingFilters);
				this.updatingFilters = setTimeout(function (speed) { this.updateWatcher(speed); }.bind(this), 300);
			}
			else {
				this.updateFilterVisibility(speed);
			}
		}

	});
	
	TargetedSearch.toInit(function ($) {
	    if (window.location.pathname.indexOf('login.action') != -1) return;
        
		TargetedSearch.Labels = new TargetedSearchLabels();
	});

})(jQuery);