(function ($) { 
	
	/*
		If provided, listener may implement:
			filterAdded($filter) 	- called when a filter is added to the selected filters
			filterRemoved($filter, noSearchUpdate) 	- called when a filter is removed from the selected filters; noSearchUpdate is true when deselecting old filters
	*/

	TargetedSearch.SelectedFilters = function (element, searchForm, listener) {
		this.element = $(element);
		this.searchForm = searchForm;
		this.listener = listener;
		this.initialize();
		this.debug = false;
	};
	
	Object.assign(TargetedSearch.SelectedFilters.prototype, {

		addFilter: function ($filter, filterClass, filter) {
			if (this.debug) console.log("addFilter", $filter, filterClass, filter);

			// Remove any other selected simple filters
			if (filterClass == "simple-filter") this.find(".simple-filter").each(function (i, filter) { this.removeFilter(filter, true); }.bind(this));
			
			// Remove any other selected date range filters
			if (filterClass == "date-range") {
				var hasRange = $filter.data("label");
				this.find(".date-range").each(function (i, filter) { this.removeFilter(filter, hasRange); }.bind(this));
				if (!hasRange) return;
			}
			
			var label;
			var displayText;
			
			if (filter) {
				label = filter.label;
				displayText = filter.displayString;
			}
			else {
				label = $filter.data("label");
                if (!label && $filter.val) label = $filter.val();
				displayText = $filter.is("[data-display-name]") ? $filter.data("display-name") : $.trim($filter.text());
				if (filterClass == "space-category") displayText = TargetedSearch.getText("com.brikit.targetedsearch.content.spaces.in.category", displayText);
			}

            // Remove the filter if it already exists so it gets re-added at the end
            this.find(".aui-label[data-id='" + label + "']").remove();

			var $lozenge = TargetedSearch.auiLabelLozengeHTML(label, displayText, "selected-filter " + filterClass, true);
			if (filter) $lozenge.data("filter", filter);
			$lozenge.attr("data-filter-type", filterClass);
			this.element.append($lozenge.hide().fadeIn("medium").css("display", "inline-block"));
			if (this.listener && this.listener.filterAdded) this.listener.filterAdded($lozenge);
		},
	
		addFilterClicked: function (e, filterClass) {
			e.preventDefault();
			var $filter = $(event.target);
			this.addFilter($filter, filterClass);
		},
	
		find: function (selector) {
			return selector ? $(selector, this.element) : this.element;
		},

		hasSearchCriteria: function () {
			return this.selectedFilters().length;
		},
		
		initialize: function () {
			var self = this;
			this.element.on("click", ".aui-icon-close", function (e) { self.removeFilterClicked(e, this) });
		},
		
		removeAll: function () {
			this.selectedFilters().remove();
		},
	
		removeFilter: function ($filter, noSearchUpdate) {
			if (this.debug) console.log("removeFilter", $filter);

			this.searchForm.removeFilterFromSelections($filter);
			if (this.listener && this.listener.filterRemoved) this.listener.filterRemoved($filter, noSearchUpdate);
		},
		
		removeFilterClicked: function (e, selected) {
			e.preventDefault();
			var $filter = $(selected).closest(".selected-filter");
			this.removeFilter($filter);
		},
		
		removeFilterForLabel: function (label, filterType) {
			var $filter = this.find("." + filterType + ".selected-filter[data-id='" + label + "']");
			this.removeFilter($filter);
		},
        
        selectedFilter: function(filterType, value) {
            return this.find("[data-filter-type='" + filterType + "'][data-id='" + value + "']");
        },
		
		selectedFilters: function (filterTypeClass) {
			return this.find((filterTypeClass ? filterTypeClass : "") + ".selected-filter:not(.removed)");
		},
		
		updateSearchFiltersFromSelections: function () {
			this.searchForm.hasSelectedFilters(this.hasSearchCriteria());
			this.updateSearchSelections(".selected-search-filters", ".filter", "searchFilters");
			this.updateSearchSelections(".selected-search-filters", ".simple-filter", "searchFilters", true);
			this.updateSearchSelections(".selected-search-filters", ".folksonomy", "searchFilters", true);
			this.updateSearchSelections(".selected-space-categories", ".space-category", "searchScope");
			this.updateSearchSelections(".selected-spaces", ".space", "spaceSearchScope");
			this.updateSearchSelections(".selected-content-types", ".content-type", "contentTypes");
			this.updateSearchSelections(".selected-date-range", ".date-range", "lastModified");
			this.updateSearchSelections(".selected-contributors", ".contributor", "contributors");
		},
	
		updateSearchSelections: function (containerSelector, filterTypeClass, fieldName, doNotEmptyContainer) {
			if (!doNotEmptyContainer) this.searchForm.emptyFilterContainer(containerSelector);
			this.selectedFilters(".selected-filter" + filterTypeClass + ":not(.removed)").each(function (i, filter) {
				this.searchForm.addFilterToContainer(containerSelector, fieldName, $(filter).data("id"));
			}.bind(this));
		}
	
	});
		
})(jQuery);
