(function ($) { 

	TargetedSearch.LabelSelectField = {
		
		// element is a DOM element inside the label select field
		// If showForm is true, display the form, otherwise display the lozenges
		adjustVisibility: function (element, showForm) {
			var $labelSelectField = TargetedSearch.LabelSelectField.labelSelectField(element);
			$labelSelectField.find(".applied-labels").hideIf(showForm);
			var $expandContent = $labelSelectField.find(".brikit-expander-content");
			var $expandControl = $labelSelectField.find(".brikit-expander-control");
			if ($expandControl.length) {
				if ($expandControl.hasClass("expanded") != showForm) $expandControl.click();
			}
			else {
				$expandControl.adjustClass("expanded", showForm);
				$expandContent.showIf(showForm);
			}
		},

		changeLabels: function (event) {
			event.preventDefault();
			
			var $form = TargetedSearch.LabelSelectField.form(this);
			$form.find(".buttons").empty().spin().find(".spinner").css("top", "12px");
			$form.submit();
		},
		
		expanderFired: function () {
			TargetedSearch.LabelSelectField.adjustVisibility(this, $(this).isShowing());
		},
		
		form: function (element) {
			return TargetedSearch.LabelSelectField.labelSelectField(element).find(".label-select-field-form");
		},
		
		initialize: function () {
			var $labelSelectField = $(this);

			var $form = $labelSelectField.find(".label-select-field-form");

			if ($form.length && TargetedSearch.pageId == $form.find("input[name=pageId]").val()) {
				$(".buttons .submit", $labelSelectField).click(TargetedSearch.LabelSelectField.changeLabels);
				$(".buttons .cancel", $labelSelectField).click(TargetedSearch.LabelSelectField.showLozenges);
				
				// Before letting the user mess with the selections, store the original values to allow resetting the form
				// if the user hits cancel
				var selection = [];
				$form.find("select option:selected").each(function () { selection.push($(this).attr("value")); });
				$form.data("page-labels", selection);
				
				TargetedSearch.LabelSelectField.selectField($form).auiSelect2();
			}
		},
		
		labelSelectField: function (element) {
			return $(element).closest(".label-select-field");
		},
		
		resetLabels: function (element) {
			var $form = TargetedSearch.LabelSelectField.form(element);
			TargetedSearch.LabelSelectField.selectField($form).select2("val", $form.data("page-labels"));
		},
		
		selectField: function (element) {
			return TargetedSearch.LabelSelectField.form(element).find("select.select");
		},

		showLozenges: function (event) {
			event.preventDefault();
			TargetedSearch.LabelSelectField.adjustVisibility(this, false);
		}
		
	};
	
	TargetedSearch.toInit(function () {
		$(".label-select-field .brikit-expander").initializeExpanderIE11Safe(TargetedSearch.LabelSelectField.expanderFired);
		$(".label-select-field").each(TargetedSearch.LabelSelectField.initialize);
	});

})(jQuery);
