/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.tiles;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.brikit.pinboards.model.FeedEntry;
import com.brikit.pinboards.tiles.Tile;
import java.io.IOException;
import java.util.Arrays;

public class PageTile
extends Tile {
    public static final String PINBOARD_PAGE_TEMPLATE = "pinboards/html/macros/pinboard-page-template.vm";

    protected PageTile(FeedEntry feedEntry, ConfluenceEntityObject content, ConfluenceActionSupport action) {
        super(feedEntry, content, action);
    }

    @Override
    public AbstractPage getPageContext() {
        return (AbstractPage)this.getContent();
    }

    @Override
    public String getRenderedContent() throws IOException {
        String storageFormat = null;
        try {
            MacroDefinition macro = MacroParser.firstMacro((AbstractPage)this.getPageContext(), (String)"excerpt");
            if (macro == null) {
                macro = MacroParser.firstMacro((AbstractPage)this.getPageContext(), (String)"content-block");
            }
            if (macro != null) {
                storageFormat = macro.getBodyText();
            }
        }
        catch (XhtmlException ex) {
            BrikitLog.logError((String)("Unable to parse blocks from " + String.valueOf(this.getPageContext())), (Exception)((Object)ex));
            return null;
        }
        if (!BrikitString.isSet((String)storageFormat)) {
            storageFormat = Confluence.getBodyAsString((ContentEntityObject)this.getPageContext());
        }
        if (MacroParser.hasMacroInStorageFormat((AbstractPage)this.getPageContext(), (String)storageFormat, (String)"pinboard")) {
            return Confluence.getText((String)"com.brikit.pinboards.error.cannot.render.page.with.pinboard.macro", Arrays.asList(this.getPageContext().getTitle()));
        }
        return Confluence.render((String)storageFormat, (AbstractPage)this.getPageContext());
    }

    @Override
    public String getTemplateLocation() {
        return PINBOARD_PAGE_TEMPLATE;
    }
}

