(function ($) { 

	// To simplify brikit-core, reference core javascript using BrikitCore
	var BrikitCore = this[brikitProduct];
	
	BrikitCore.extend({
		
		cookies: [],
		
		// Set a cookie that expires in minutes, or session if minutes not provided
		cookie: function (cookie, value, minutes) {
			if (typeof(value) == "undefined") return $.cookie(cookie);
			
			// Keep track of Brikit cookies so they can be zapped when asked
			if (BrikitCore.cookies.indexOf(cookie) == -1) BrikitCore.cookies.push(cookie);
		
			var opts = { path: "/" };
			if (minutes) opts.expires = new Date(new Date().getTime() + minutes * 60000);
			$.cookie(cookie, value, opts);
		},
		
		// Keep track of Brikit cookies so they can be zapped when asked
		registerCookie: function (cookie) {
			if (BrikitCore.cookies.indexOf(cookie) == -1) BrikitCore.cookies.push(cookie);
		},

		zapCookie: function (cookie) {
			$.cookie(cookie, null, {path: "/"});
		},
		
		// Easter egg to zap cookies set in product
		zapCookies: function () {
			var zapped = "";
			$(BrikitCore.cookies).each(function () { 
				var value = BrikitCore.cookie(this);
				if (!value) return;
				BrikitCore.zapCookie(this);
				zapped += this + "<br/>";
			});
			BrikitCore.Dialog.alert("<p>" + (zapped.length ? zapped : BrikitCore.getText("com.brikit.core.no.browser.cookies.found")) + "</p>", {title: BrikitCore.getText("com.brikit.core.cleared.browser.cookies"), height: 300});
		}

	});
		
	BrikitCore.toInit( function ($) {
		// Easter egg to zap user cookies
		AJS.whenIType("qqqq").execute(BrikitCore.zapCookies);
	});

})(jQuery);
