Array.prototype.diff = function(a) {
    return this.filter(function(i) {return a.indexOf(i) < 0;});
};

// Return true if both arrays have the same elements, regardless of order
Array.prototype.equals = function(a) {
    return typeof(a) == "object" && this.length == a.length && !this.diff(a).length;
};

// Return true if both arrays have the same elements, in the same order
Array.prototype.exactlyEquals = function(a) {
	if (a === this) return true;
	if (a == null || a.length != this.length) return false;

	for (var i = 0; i < a.length; ++i) {
		if (a[i] != this[i]) return false;
	}
	return true;
};

Array.prototype.remove = function (e) {
	var index = this.indexOf(e);
	if (index > -1) this.splice(index, 1);
	return this;
};

Array.prototype.removeAll = function (a) {
	for (var i = 0; i < a.length; ++i) {
		if (this.indexOf(a[i]) != -1) this.remove(a[i]);
	}
};
